/**
 *  Positive Incident Model
 */
Ext.define('Academia.model.personinfo.common.disciplinaryactivity.PositiveIncidentModel', {
    extend: "Ext.data.Model",
    fields: ['person', 'type', 'documents','incidentDate', 'reportedByUserId', 'reportedByUserName', 'actionTaken', 'honourName', 'remarks',
    	'categoryOfIncident','incidentRating','incidentDetails','studentsInvolved','uniqueIdentifier','customData','id','version','studentIncidentDate','studentDateOfAction',
    	{
            name:'categoryOfIncidentValue',
            convert: function(v, rec) {
                if(rec.data.categoryOfIncident && !isNullOrEmpty(rec.data.categoryOfIncident.value)){
                    return rec.data.categoryOfIncident.value;
                }
                else{
                    return "";
                }
            }
        },{
            name:'typeValue',
            convert: function(v, rec) {
                if(rec.data.type && !isNullOrEmpty(rec.data.type.value)){
                    return rec.data.type.value;
                }
                else{
                    return "";
                }
            }
        },{
            name:'incidentRatingValue',
            convert: function(v, rec) {
                if(rec.data.incidentRating && !isNullOrEmpty(rec.data.incidentRating.value)){
                    return rec.data.incidentRating.value;
                }
                else{
                    return "";
                }
            }
        }]
});