/**
 * This store is for displaying the Transfer Seats in Admission Selection Stage.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.store.admission.selectionStage.TransferSeats', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.admission.selectionStage.StageStatistic',
	autoLoad : false,
	pageSize : CONSTANTS.DEFAULT_PAGESIZE,
	proxy : {
		type : 'jsonajax',
		header: {
            contentType: 'application/json'
        },
        actionMethods: {
            read: 'POST'
        },  
		api : {
				read : SERVERURL.STAGESTATASTICSFINDBYCRITERIA
		},
		reader : {
			type : 'json',
			root : 'rows',
			totalProperty: 'records'
		}
	}
	, filterGrid : function(filterId) {
		this$ = this;
		if(filterId.length <= 0) {
				this$.removeFilter();
		}
		
		if(filterId.length != 0) {
			this$.filterBy(function(record, id){
				var recordFlag = false;
				Ext.each(filterId, function(filter) {
					if(record.get('quotaTypeId') === filter) {
						recordFlag = true;
					};
				});
			    return recordFlag;
			}, this);
		}
	}
});
