/**
 * @author Rajkumar.patidar
 */

Ext.define('Academia.store.campaign.UserByAcademyLocation',{
	extend : 'Ext.data.Store',
	model : 'Academia.model.common.IdValueDataModel',
	autoLoad : false,	
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('value');
	        var value2 = o2.get('value');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.USER_BY_ACADEMY_LOCATION
		},
		reader : {
			type : 'json'
		}
	}

});

