/**
 * @author Deepak Sharma
 */

Ext.define('Academia.store.common.OtherAddressCopyStore', {
    extend: 'Ext.data.Store',
    model: 'Academia.model.common.OtherAddressCopyModel',
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.FIND_OTHER_ADDRESS_TYPE
        },
        reader: {
            type: 'json'
        }
    },
    listeners:{
    	load: function(store, records, successful, eOpts) {
        	for (var count = 0; count < records.length; count++) {
        		var key = '';
        		var permissionKey = '';

        		if ('ORG' == records[count].get("addressCategory") && 'REG' == records[count].get("code") ) {
        			key = getCommonTranslation('REGISTERED_OFFICE');
        		} else if ('ORG' == records[count].get("addressCategory") && 'RES' == records[count].get("code") ) {
        			key = getCommonTranslation('WORK_ADDRESS');
        		} else if ('PERSON' == records[count].get("addressCategory") && 'CRNT' == records[count].get("code") ) {
        			key = getPersonModuleTranslation('CURRENT_ADDRESS');
        			permissionKey = 'CURRENT_ADDRESS';
        		} else if ('PERSON' == records[count].get("addressCategory") && 'CRSPDNC' == records[count].get("code") ) {
        			key = getPersonModuleTranslation('ADDRESS_FOR_CORRESPONDANCE');
        			permissionKey = 'ADDRESS_FOR_CORRESPONDANCE';
        		} else if ('PERSON' == records[count].get("addressCategory") && 'PRMNT' == records[count].get("code") ) {
        			key = getPersonModuleTranslation('PERMANENT_ADDRESS');
        			permissionKey = 'PERMANENT_ADDRESS';
        		} else if ('PERSON' == records[count].get("addressCategory") && 'OFC' == records[count].get("code") ) {
        			key = getPersonModuleTranslation('OFFICE_ADDRESS');
        			permissionKey = 'OFFICE_ADDRESS';
        		} /*else if ('PERSON' == records[count].get("addressCategory") && 'GOOGLE' == records[count].get("code") ) {
        			key = getPersonModuleTranslation('GOOGLE_ADDRESS');
        			permissionKey = 'GOOGLE_ADDRESS';
        		}*/

        		if (!isNullOrEmpty(key)) {
        			//records[count].set('addressTypeName', key);
        			records[count].set('permissionKey', permissionKey);
        		}
        	}
        	store.commitChanges();
        }
    }
    
});
