/**
 * This store is used for service request sub category
 * @author Sachin.Bangar
 */
Ext.define('Academia.store.reports.servicerequest.SystemUsersByAcademyLocationIds', {
    extend: 'Ext.data.Store',
    model : 'Academia.model.common.LiveSearchComboModel',
    autoLoad: false,
    proxy: {
    	type: 'jsonajax',
    	pageParam: undefined,
    	startParam: undefined, 
    	limitParam: undefined,
        header: {
            contentType: 'application/json'
        },
        api: {
        	read:SERVERURL.SYSTEM_USERS_BY_ACADEMY_LOCATION_IDS
        },
        actionMethods: {
            read: 'POST'
        },
        reader: {
            type: 'json'
        }
    },
	
    listeners: {
        load: {
            element: 'el',
            fn: function(store, records, successful, eOpts) {
                var me = this;
                if(records){
                	for (var count = 0; count < records.length; count++) {
                		var record = records[count];
                		var concatValue = "";
                		/*concatValue = me.concatValue(concatValue, record, 'firstName');
                    concatValue = me.concatValue(concatValue, record, 'lastName');
                    concatValue = me.concatBracketWithValue(concatValue, record, 'code');*/
                		concatValue = record.get('code') + ' / '+  record.get('printName');
                		records[count].set('value', concatValue);
                	}
                }
                store.commitChanges();
            }
        }
    },
    concatValue: function(concatValue, record, key) {
        var value = record.get(key);
        if (!isNullOrEmpty(value)) {
            concatValue = concatValue.concat("  " + value);
            return concatValue;
        } else {
            return concatValue;
        }
    },
    concatBracketWithValue : function (concatValue, record, key){
    	var value = record.get(key);
        if (!isNullOrEmpty(value)) {
            concatValue = concatValue.concat("  [" + value+"]");
            return concatValue;
        } else {
            return concatValue;
        }
    }
});