/**
  * Plugin (ptype = 'formlabelrequired') that adds "asterisk" to labels
  * for Fields with "allowBlank: false".
  */
 Ext.define('Academia.utilities.plugins.AsteriskPlugin', {
	 
		extend: 'Ext.AbstractPlugin',

	    alias: 'plugin.formlabelrequired',

	    asterisk: ' <span class="required" style="color:red"> *</span>',

	    constructor: function() {    	
	        this.callParent(arguments);
	    },

	    init: function(formPanel) {    	      
	        formPanel.on('beforerender', this.onBeforeRender, this);
	    },

	    /**
	     * @private
	     * Adds asterisk to labels.
	     */
	    onBeforeRender: function(formPanel) {	    		    
	        
	    	var i, len, items;

	        items = formPanel.query('[allowBlank=false]');

	        for (i = 0, len = items.length; i < len; i++) {
	            var item = items[i];
	            item.afterLabelTextTpl = (item.afterLabelTextTpl || "") + this.asterisk;
	        }
	        return true;
	    }
	});