/**
 * @Author Akshay.Kalbhor
 */
Ext.define('Academia.utilities.reader.CustomArrayReader',{
	extend: 'Ext.data.reader.Json',
	alias: 'reader.customarrayreader',
	constructor: function(cnfg){
		if(!cnfg)
			cnfg={};
		this.callParent(arguments);
		this.initConfig(cnfg);
	},
	
	getResponseData: function(response) {
	        var data, error;
	 
	        try {
	            data = Ext.decode(response.responseText);
	            var result = [];
	            for (var i=0;i<data.length;i++)
	            { 
        	      var dataValue = new Object();
        	      translatedValue = getCommonTranslation(data[i]);
        	      dataValue.id = data[i];
        	      dataValue.value = translatedValue;
        	      result.push(dataValue);
	            }
	            return this.readRecords(result);
	        } catch (ex) {
	            error = new Ext.data.ResultSet({
	                total  : 0,
	                count  : 0,
	                records: [],
	                success: false,
	                message: ex.message
	            });

	            this.fireEvent('exception', this, response, error);

	            Ext.Logger.warn('Unable to parse the JSON returned by the server');

	            return error;
	        }
	    }
});