/**
 * This column series used for auto grouped column
 * @author Sachin.Bangar
 */
Ext.define('Academia.utilities.ux.AutoGroupedColumn', {
    extend: 'Ext.chart.series.Column',
    type: 'autogroupedcolumn',
    alias: 'series.autogroupedcolumn',
    gField: null,
    constructor: function( config ) {
        this.callParent( arguments );
        // apply any additional config supplied for this extender
        Ext.apply( this, config );
        var me = this,
            store = me.chart.getStore(),
            // get groups from store (make sure store is grouped)
            groups = store.isGrouped() ? store.getGroups() : [],
            // collect all unique values for the new grouping field
            groupers = store.collect( me.gField ),
            // blank array to hold our new field definitions (based on groupers collected from store)
            fields = [];
        // first off, we want the xField to be a part of our new Model definition, so add it first
        fields.push( {name: me.xField } );
        // now loop over the groupers (unique values from our store which match the gField)
        for( var i in groupers ) {
            // for each value, add a field definition...this will give us the flat, in-record column for each group 
            fields.push( { name: groupers[i], type: 'int' } );
        }
        // let's create a new Model definition, based on what we determined above
        Ext.define('GroupedResult', {
            extend: 'Ext.data.Model',
            fields: fields
        });
        // now create a new store using our new model
        var newStore = Ext.create('Ext.data.Store', {
            model: 'GroupedResult'
        });
        // now for the money-maker; loop over the current groups in our store
        for( var i in groups ) {
            // get a sample model from the group
            var curModel = groups[ i ].children[ 0 ];
            // create a new instance of our new Model
            var newModel = Ext.create('GroupedResult');
                // set the property in the model that corresponds to our xField config
                newModel.set( me.xField, curModel.get( me.xField ) );
            // now loop over each of the records within the old store's current group
            for( var x in groups[ i ].children ) {
                // get the record
                var dataModel = groups[ i ].children[ x ];
                // get the property and value that correspond to gField AND yField
                var dataProperty = dataModel.get( me.gField );
                var dataValue = dataModel.get( me.yField );
                // update the value for the property in the Model instance
                newModel.set( dataProperty, dataValue ); 
                // add the Model instance to the new Store
                newStore.add( newModel );
            }
        }
        // now we have to fix the axes so they work
        // for each axes...
        me.chart.axes.each( function( item, index, len ) {
            // if array of fields
            if( typeof item.fields=='object' ) {
                // loop over the axis' fields
                for( var i in item.fields ) {
                    // if the field matches the yField config, remove the old field and replace with the grouping fields
                    if( item.fields[ i ]==me.yField ) {
                       Ext.Array.erase( item.fields, i, 1 );
                       Ext.Array.insert( item.fields, i, groupers );
                       break;
                    }
                } 
            }
            // if simple string
            else {
                // if field matches the yField config, overwrite with grouping fields (string or array)
                if( item.fields==me.yField ) {
                    item.fields = groupers;
                }
            }
        });
        // set series fields and yField config to the new groupers
        me.fields,me.yField = groupers;
        // update chart's store config, and re-bind the store
        me.chart.store = newStore;
        me.chart.bindStore( me.chart.store, true );
        // done!
    }
});