Ext.define('Academia.view.DMSView.SiteMembersCenterPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.sitememberscenterpanel',
    margin: 0,
    items:[{
    	xtype: 'panel',
    	autoScroll: true,
        frame: true,
        border: true,
        height: 580,
        bodyStyle:{
        	padding: 0
        },
        title: getDMSTranslation('SEARCH_SITE_MEMBERS'),
    	items:[{
        	xtype: 'textfield',
        	width:'100%',
        	emptyText: getDMSTranslation('SEARCH'),
        	itemId: 'siteMembersSearchMappedUser',
        	enableKeyEvents: true
        },{
        	xtype: 'dataview',
        	itemId: 'siteMembersUserListDataViewItemId',
        	height: '90%',
        	autoScroll: true,
        	store: Ext.create('Academia.store.DMSStore.DMSSiteUserListStore'),
    	    tpl: new Ext.XTemplate(
    	    	    '<tpl for=".">',
    	            '<div class="thumb-wrap">',
    	              '<img src="resources/images/dms_user.png" />',
    	              '<div>',
    	              	'<span class="dmsUserListNameSpan">{[this.getUserName(values)]}</span><br />',
    	              	'<span style="float: left;">{[this.getRole(values)]}</span>',
    	              	'<span {[this.getClass(values)]}>x</span>',
    	              	'{[this.getApproveRejectBtns(values)]}',
    	              '</div>',
    	            '</div>',
    	        '</tpl>',
    	        {
    	    	    getUserName: function(values){
    	    	    	if(values.authorityType=="PENDING_REQUESTS"){
    	    	    		return "From: "+values.firstName+" "+ values.lastName+" ("+values.userName+")";
    	    	    	}
    	    	    	else{
    	    	    		return values.firstName+" "+ values.lastName;
    	    	    	}
    	    	    },
    	    	    getRole: function(values){
    	    	    	if(values.authorityType=="PENDING_REQUESTS"){
    	    	    		return "Sent: "+new Date(values.role).toLocaleString();
    	    	    	}
    	    	    	else{
    	    	    		return values.role;
    	    	    	}
    	    	    },
        	    	getClass: function(values){
        	    		if(values.role=="Manager"){
    	    	    		var classList = "style='display:none;'";
        	    		}
        	    		else{
    	    	    		var classList = "class='deleteIcon' style='left: 80%;'";
        	    		}
        	    		if(!values.isEditable){
        	    			var classList = "style='display:none;'";
        	    		}
        	    		return classList;
        	    	},
        	    	getApproveRejectBtns: function(values){
        	    		if(values.authorityType=="PENDING_REQUESTS"){
        	    			return "<span class='siteUserApproveBtn'>Approve</span><span class='siteUserRejectBtn'>Reject</span>";
        	    		}
        	    		else{
        	    			return "";
        	    		}
        	    	}
    	        }
    	    ),
    	    itemSelector: 'div.thumb-wrap',
    	    emptyText: 'No data available',
        }]
    }]
});