/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.admissionActivityReport.SaleAdmissionEnrolAcademyByDayAdmGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.saleadmissionenrolacademybydayadmgrid',
	store: 'admission.admissionActivityReport.AdmissionEnrolAcademyByDayAdmGridStore',
	title: getAdmissionTranslation('SALES_ADMISSION_DAY_BY_ACADEMY'),
	border: true,
	frame: false,
	cls : 'linkedAcademyLocation',
	viewConfig: {
		getRowClass: function (record, rowIndex, rowParams, store) {
			return (record.get('total') == 'total') ? 'gridAdmActivityReportEnrol' : '';
		},
		stripeRows: CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	columns: [{
		header: getCommonTranslation('ACADEMY'),
		dataIndex: 'academyLocationName',
		flex: 1.5,
		sortable: false
	},{
		header: getCommonTranslation('INTAKE_YEAR'),
		dataIndex: 'intakeYear',
		flex: 1,
		sortable: false
	},{
		header: getCommonTranslation('DATE'),
		dataIndex: 'date',
		flex: 1,
		sortable: false,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header: getAdmissionTranslation('ACADEMY_ENQUIRIES'),
		dataIndex: 'noOfEnquiry',
		flex: 1,
		sortable: false
	},{
		header: getAdmissionTranslation('ACADEMY_APPLICATIONS'),
		dataIndex: 'noOfApplication',
		flex: 1,
		sortable: false
	}, {
		header: getAdmissionTranslation('ACADEMY_ACCEPTED_APPLICATIONS'),
		dataIndex: 'noOfApprovedApplication',
		flex: 1,
		sortable: false
	},{
		header: getAdmissionTranslation('ACADEMY_ADMISSION'),
		dataIndex: 'noOfApprovedAdmission',
		flex: 1,
		sortable: false
	}]
});
