/**
 * @author Archita Malviys
 */
Ext.define('Academia.view.admission.admissionCycle.AdmissionSetupUpdatesUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.admissionsetupupdatesuploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	cls:'customSearchPanel',
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'importAdmissionSetupUpdatesRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('TEMPLATE_NAME'),            
            itemId: 'moduleName',
            name: 'importUtilityMasterId',
            store: 'importutility.ModuleName',
            valueField: 'id',
            displayField: 'value',
            //value:'Bulk Admission Setup Update',
            width:420,
            labelAlign: 'top',
			readOnly:true,
			typeAhead:true,
			forceSelection:true,
			allowBlank:false
        	}]
	},{
		xtype:'fieldcontainer',
		items: [{
			xtype : 'filefield',
			ui : 'CustomBtnThird',
			width: 460,
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText : getCommonTranslation('BROWSE_FILE'),
			itemId : 'uploadFileField',
			name : 'file',
			labelAlign: 'top',
			allowBlank:false,
			validateOnChange : true,
			listeners:{
	            change: function(fileField, value) {
	                value = value.replace('C:\\fakepath\\', '');
	                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                fileField.setRawValue(newValue);
	                if (!isNullOrEmpty(newValue)) {
	                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
	                    if (!baseController.isValidFileExtensionForLoader(extension)) {
	                        fileField.reset();
	                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
	                    }
	                }
	            }
	        }
		}]
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			disabled:true,
			itemId: 'uploadAdmissionSetupUpdateFormItemId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
