/**
 * @author <a href="mailto:vidhi.shah@serosoft.in">Vidhi Shah</a>
 * 
 */
//var admissionRequirementDetail = Ext.create('Academia.store.enquiry.admission.AdmissionReqmntStore');
Ext.define('Academia.view.admission.applicationFormSale.ApplicationProgramDetailGrid', {
	 extend: 'Ext.grid.Panel',
	alias : 'widget.applicationprogramdetailgrid',
//    store : admissionRequirementDetail,
    title: getAdmissionTranslation('APPLICATION_PROGRAM_GRID'),
	border: true,
	autoScroll: false,
	id:'admissionrqmnt_grid',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
        xtype: 'toolbar',
        hidden:true,
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')
        }]
    }],
	initComponent: function() {    	     
     	var grid=this;
     	var store = grid.buildStore();
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
     },
	columns : [{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academy.value',
		flex : 1
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'location.value',
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'program.value',
		flex :1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
			
		}
	},{
		header : getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex : 'modeOfDelivery.value',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex : 'batchPartTime',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				if(value){
					return 'Part Time'
				}else{
					return 'Full Time'
				}
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex:'batch.value',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType.value',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('OFFER_STATUS'),
		dataIndex:'currentStatus',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return getAdmissionTranslation(value);
			}else{
				return '-';
			}
		}
	}],
	buildStore: function() {
        return Ext.create('Academia.store.admission.applicationFormSale.ApplicationProgramDetailStore');
    }
});