/**

 * @author <a href="mailto:vidhi.shah@serosoft.in">Vidhi Shah</a>
 * 
 */
Ext.define('Academia.view.admission.applicationFormSale.SendOfferLetterForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.sendofferletterform',
	autoScroll: true,
    border: false,
    frame: false,
    plugins: "formlabelrequired",
    items: [{
		        xtype: 'hidden',
		        itemId: 'applicationProgramId',
		        name: 'applicationProgramId'
		    }, {
		        xtype: 'hidden',
		        itemId: 'programBatchSeatConfigId',
		        name: 'programBatchSeatConfigId'
		    },{
		    	xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 300
                },
                items: [{
                	xtype : 'radiogroup',
                	itemId:'offerType',
                	name:'offerType',
                	labelAlign : 'top',
                	height:60,
                	fieldLabel:getAdmissionTranslation('OFFER_TYPE'),
                	items : [{
                		boxLabel : getAdmissionTranslation('FIRM_OFFER'),
                		name:'isOfferType',
                		inputValue : 'true',
                		checked : true
                	},{
                		boxLabel : getAdmissionTranslation('PROVISIONAL_OFFER'),
                		name:'isOfferType',	
                		inputValue : 'false'
                	}],
                	listeners: {
                		change: function (field, newValue) {
                            var conditionApplicable = field.up('form').down('#conditionApplicable');
                            var yesOption = conditionApplicable.items.items[0]; // Assuming the first item is the "Yes" option
                            var noOption = conditionApplicable.items.items[1]; // Assuming the second item is the "No" option

                            if (newValue.isOfferType === 'false') { // PROVISIONAL_OFFER selected
                                noOption.setDisabled(true);
                                yesOption.setValue(true); // Select "Yes" by default
                            } else {
                                noOption.setDisabled(false); // Enable the "No" option if not PROVISIONAL_OFFER
                            }
                        }
                    }           
                }, {
                	xtype : 'radiogroup',
                	itemId:'conditionApplicable',
                	name:'conditionApplicable',
                	labelAlign : 'top',
                	height:60,
                	labelSeparator : '',
                	fieldLabel:getAdmissionTranslation('CONDITION_APPLICABLE'),
                	items : [{
                		boxLabel : getCommonTranslation('YES'),
                		name:'isConditionApplicable',
                		inputValue : 'true',
                		checked : true
                	},{
                		boxLabel : getCommonTranslation('NO'),
                		name:'isConditionApplicable',	
                		inputValue : 'false'
                	}]           
                }, {
                	xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('OFFER_LETTER'),
                    name: 'offerLetter',
                    valueField: 'id',
                    displayField: 'value',
                    itemId: 'offerLetter',
                    store: Ext.create('Academia.store.admission.applicationFormSale.GetOfferLetterTemplateStore'),
                    editable: false
                }]
            },{
            	xtype:'fieldcontainer',
				itemId:'applicableAdmissionPanelId',
				items:[{
		            xtype: 'fieldcontainer',
		        	layout: 'hbox',
		        	width: '100%',
		        	itemId:'applicableAdmissionPanel',
		        	defaults: {
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        	    xtype: 'customcombobox',
		      			name: 'applicableAdmissionCondition',
		      			itemId: 'applicableAdmissionCondition',
		      			allowBlank: false,
		      			fieldLabel: getAdmissionTranslation('APPLICABLE_ADMISSION_CONDITION'),
		      			store: 'admission.applicationFormSale.AdmissionConditionByOfferTypeStore',
		      			displayField: 'value',
		                valueField: 'id',
		      			forceSelection:true,
		      			queryParam:'qry',
						editable:false,
						width: 300,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							}
						}
		         	 }, {
		        		xtype: 'textarea',
		     			name: 'additionlConditions',
		     			itemId: 'additionlConditions',
		     			fieldLabel: getAdmissionTranslation('ADDITIONAL_CONDITIONS'),
		     			editable:false,
		     			readOnly: true,
		     			maxLength:2000,
		     			width: 300,
		     			listeners: {
                            change:function(obj,value){
                            	obj.getEl().dom.setAttribute('data-qtip',value);
                            	obj.getEl().dom.style.textAlign = 'left';
                            	obj.getEl().dom.style.overflow = 'hidden'; 
                            	return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + value + '} </div>';
                           }
                        }
		        	 }, {
		        		 xtype: 'datefield',
		                 fieldLabel: getAdmissionTranslation('DATE_FOR_SATISFACTION_OF_CONDITION'),
		                 name: 'dateOfSatisfactionCondition',
		                 itemId: 'dateOfSatisfactionCondition',
		                 vtype: 'daterange',
		                 width: 260,
		                 listeners: {
		                 	render: function(field) {
		                 		return dateFormatRender(field);
		                 	}
		                 },
		                 minValue: new Date()
		        	 },{
						xtype: 'button',
						itemId: 'addConditionBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						width:30,
						style:{
							marginTop:'30px'
						}
		        	}]
		       }]
         },{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	defaults: {
            		labelAlign: 'top',
            		width: 300
            	},
            	items: [{
        		xtype: 'multiselectcombofield',
      			name: 'documentApplicable',
      			itemId: 'documentApplicable',
      			store: Ext.create('Academia.store.common.DocumentTypeStore'),
      			displayField: 'value',
                valueField: 'id',
      			fieldLabel: getAdmissionTranslation('DOCUMENT_APPLICABLE'),
      			cls:'commonAutoHeightMultiselectField',
        		forceSelection:true,
        		listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('multiselectcombofield').getSize().width;
							picker.width = picker.up('multiselectcombofield').getSize().width;
						}
					}
      			}
         	 }]
    }, {
            	xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 300
                },
                items: [{
	            	xtype : 'radiogroup',
	            	itemId:'escalationRequired',
	            	name:'escalationRequired',
	            	labelAlign : 'top',
	            	height:60,
	            	labelSeparator : '',
	            	fieldLabel:getAdmissionTranslation('ESCALATION_REQUIRED'),
	            	items : [{
	            		boxLabel : getCommonTranslation('YES'),
	            		name:'isEscalationRequired',
	            		inputValue : 'true',
	            		checked : true
	            	},{
	            		boxLabel : getCommonTranslation('NO'),
	            		name:'isEscalationRequired',	
	            		inputValue : 'false'
	            	}]           
	            }, {
	            	xtype: 'customcombobox',
					name: 'assignedTo',
					itemId:'assignedTo',
					store: Ext.create('Academia.store.common.AssignReviewersToApplicationsStore'),
					fieldLabel: getCommonTranslation('ASSIGNED_TO'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'qry',
					minChars:3,
					editable:true,
					typeAhead:true,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					allowBlank:false,
					listConfig: {
					 listeners: {
						 beforeshow: function(picker) {
							 picker.minWidth = picker.up('combobox').getSize().width;
						 }
					 },
					 loadingText: getCommonTranslation('SEARCHING'),
					 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					 getInnerTpl: function() {
						 return '<div class="search-item">' +
						 '{value}'+
						 '</div>';
					 }
					}
	          }]
        }, {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 300
                },
                items: [{
                	xtype: 'datefield',
                    fieldLabel: getAdmissionTranslation('OFFER_VALID_UNTIL'),
                    name: 'offerValidUntil',
                    itemId: 'offerValidUntil',
                    vtype: 'daterange',
                    listeners: {
                    	render: function(field) {
                    		return dateFormatRender(field);
                    	}
                    },
                    minValue: new Date()
                }]
         },{
        	 xtype: 'fieldcontainer',
        	 layout: 'hbox',
        	 defaults: {
        		 labelAlign: 'top',
        		 width: 610
        	 },
        	 items: [{
        		xtype: 'textarea',
     			name: 'escalationComments',
     			itemId: 'escalationComments',
     			fieldLabel: getAdmissionTranslation('ESCALATION_COMMENTS'),
     			maxLength:1000	
        	 }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getAdmissionTranslation('ESCALATE'),
            itemId: 'escalateButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getAdmissionTranslation('SEND'),
            itemId: 'sendButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});