/**
 * @author Trupti.Paoneker
 * 
 * This component is used for to show offer letter accepted programs in grid details.
 * 
 */
var AdmissionProgramGridStore = Ext.create('Academia.store.admission.applications.admissionAndMidTermAdmission.AdmissionProgramGridStore');
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.AdmissionProgramGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.admissionprogramgrid',    
    title: getAdmissionTranslation('ADMISSION_DETAILS'), //Admission Details    
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    isGridConfigurable: true,
    enableColumnHide: false,
    initComponent: function() {    	     
     	var grid=this;
     	var store=this.buildStore();
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }
     },
    columns: [{
        header: getCommonTranslation('ADMISSION_ID'), //Admission ID
        dataIndex: 'admissionId',        
        hidden:true,
        flex: .2
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION'), //Academy
        dataIndex: 'academy',
        flex: .2,
        renderer: function(obj,p,r) {
            return r.data['academy.value'] + ',' + r.data['location.value'];
        }
    }, /*{
        header: getAdmissionTranslation('LOCATION'), //Location
        dataIndex: 'location',        
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }*/{
        header: getCommonTranslation('PROGRAM'), //Program
        dataIndex: 'program',        
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('MODE_OF_DELIVERY'),
        dataIndex: 'modeOfDelivery',
        sortable: true,
        flex: .2,
    	hidden: true,
    	renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('REGISTRATION_TYPE'),
        dataIndex: 'batchPartTime',
        sortable: true,
        flex: .2,
    	hidden: true,
    	renderer : function(value) {
        	if(!isNullOrEmpty(value)) {
        		if(value==false) {
        			return 'Full Time';
        		}
        		else {
        			return 'Part Time';
        		}
        	}
        }
    }, {
        header: getCommonTranslation('BATCH'), //Batch
        dataIndex: 'batch',        
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatType',        
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
		header: getCommonTranslation('SCHOOL_ATTENDANCE_START_DATE'),
		dataIndex: 'schoolAttendanceStartDate',
		flex: .2,
		sortable: true,
		renderer: function(val) {
				if(!isNullOrEmpty(val)){
                   return dateRender(val);
                }
		}
	}, {
        header: getCommonTranslation('ADMISSION_TYPE'), //Admission Type
        dataIndex: 'admissionType',
        flex: .2,
        renderer : function(value){
        	return getAdmissionTranslation(value);
        }
    },{
        header: getCommonTranslation('ADMISSION_STATUS_TYPE'), //Admission Type
        dataIndex: 'status',
        flex: .2,
        renderer : function(value){
        	return getAdmissionTranslation(value);
        }
    },{
        header: getCommonTranslation('ADMISSION_DATE_AD'), //Admission Type
        dataIndex: 'admissionDate',
        flex: .2,
        hidden:true,
        renderer : function(value){
        	return dateRender(value);
        }
    }],
    tbar: [{
    	xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH	
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'	
	},{
        xtype: 'button',
        itemId: 'btnAddPrograms',
        text:  getAdmissionTranslation('ADD_PROGRAM'), //Add Program
        tooltip: getAdmissionTranslation('ADD_PROGRAM'), //Add Program       
        scale: CONSTANTS.BUTTONSIZE,
        hasDisableForProfileViewMode:true        
    }, /*{
    	 xtype: 'button',
         itemId: 'btnConfirmOrDeny',
         text:  getAdmissionTranslation('CONFIRM_OR_DENY'),  //Confirm or Deny Provisional Admission
         tooltip: getAdmissionTranslation('CONFIRM_OR_DENY'), //Confirm or Deny Provisional Admission
         scale: CONSTANTS.BUTTONSIZE,
         hasDisableForProfileViewMode:true         
    }, */{
        xtype: 'button',
        text:  getAdmissionTranslation('CONFIRM_OR_WITHDRAW'), //Confirm or Withdraw Trial Admission
        tooltip: getAdmissionTranslation('CONFIRM_OR_WITHDRAW'), //Confirm or Withdraw Trial Admission
        itemId: 'btnConfrimOrWithdraw',
        buttonAlign: 'right',        
        scale: CONSTANTS.BUTTONSIZE,
        disabled : true,
        hasDisableForProfileViewMode:true
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        //hidden:true,
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
            displayInfo: true
        }]
    }],
    buildStore: function() {
        return Ext.create('Academia.store.admission.applications.admissionAndMidTermAdmission.AdmissionProgramGridStore');
    }
});
