/**
 * @author Trupti.Paoneker
 *
 * This component is used for to show Mid Term Main Courses in grid details.
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.MidTermMainCoursesGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.midtermmaincoursesgrid',    
    title: getAdmissionTranslation('UPDATE_COURSES_STATUS'), //Update Status of Courses in the Program    
    border: true,
   /* features: [groupingFeature],*/
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    plugins: [
              Ext.create('Ext.grid.plugin.CellEditing', {
                  clicksToEdit: 1
              })
     ],
    /*features: [{
        ftype: 'grouping',
        groupHeaderTpl: '{columnName}: {name} ({rows.length} Item{[values.rows.length > 1 ? "s" : ""]})',
        hideGroupedHeader: true,
        startCollapsed: false        
    }],*/
     initComponent: function() {    	     
     	var grid=this;
     	var store=Ext.create('Academia.store.admission.applications.admissionAndMidTermAdmission.MidTermAdmMainCourseGridStore');
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }
     },
    columns: [{
        header: getAdmissionTranslation('COURSE_NAME'), //Course Name 
        dataIndex: 'courseName',        
        flex: .2
    }, {
        header: getCommonTranslation('STATUS') +' <span class="required" style="color:red"> *</span>', //Status
        dataIndex: 'status',        
        flex: .2,
        editor: {
            xtype: 'customcombobox',
            name: 'status',            
              //Select Status             
            store:'admission.applications.admissionAndMidTermAdmission.MidTermStatusComboStore',
            valueField:'name',
            displayField:'value',
            editable:false,
            queryMode:'local'            
        },
        renderer: function(val) {
            if (isNullOrEmpty(val)) {
                return getAdmissionTranslation('CLICK_HERE');  //Click Here
            } else {
                return val;
            }
        }
    }, {
        header: getAdmissionTranslation('MARKS'), //Marks
        dataIndex: 'marks',        
        flex: .1,
        editor: {
            xtype: 'numberfield',
            name: 'marks',
             //Enter Marks
            maxLength: 3,
            minValue:0
        },
        renderer: function(val) {
            if (isNullOrEmpty(val)) {
                return getAdmissionTranslation('CLICK_HERE');  //Click Here
            } else {
                return val;
            }
        }
    },{
        header: getAdmissionTranslation('GRADES'), //Grades
        dataIndex: 'grade',        
        flex: .2,
        editor: {
            xtype: 'textfield',
            name: 'grade',
             //Enter Grades
            maxLength: 50
        },
        renderer: function(val) {
            if (isNullOrEmpty(val)) {
                return getAdmissionTranslation('CLICK_HERE');  //Click Here
            } else {
                return val;
            }
        }
    },{
        header: getAdmissionTranslation('COURSE_TYPE'), //Course Type
        dataIndex: 'period',        
        flex: .2        
    }],    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }/*,{
            text:'Clear Grouping',
            iconCls: 'icon-clear-group',
            handler : function(){
                groupingFeature.disable();
            }
        }*/]        
    }]
});