/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with Other Course details.
 *  
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.OtherCourseFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.othercoursesformwindow',
    modal: true,
    resizable: false,
    title: getAdmissionTranslation('OTHER_COURSE_DETAILS'), //Other Course Details	
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'othercoursesForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'otherCoursesHiddenField',
            name: 'id'
        }, /*{
            xtype: 'hidden',
            name: 'version'
        }, */{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },

            items: [{
                fieldLabel: getAdmissionTranslation('COURSE_NAME'), //Course Name
                xtype: 'textfield',
                itemId: 'courseName',
                name: 'courseName',
                labelAlign: 'top',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
                fieldLabel: getCommonTranslation('DESCRIPTION'), //Description
                xtype: 'textareafield',
                itemId: 'description',
                name: 'description',
                labelAlign: 'top',
                allowBlank: false
            }]
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
                fieldLabel: getAdmissionTranslation('MARKS'), //Marks
                xtype: 'numberfield',
                itemId: 'marks',
                name: 'marks',
                maxLength: 5,
                minValue:0,
                labelAlign: 'top'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{        		
                fieldLabel: getAdmissionTranslation('GRADES'), //Grades
                xtype: 'textfield',
                itemId: 'grade',
                name: 'grade',
                labelAlign: 'top'
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveOtherCoursesForm',
                text: getCommonTranslation('SUBMIT'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelOtherCoursesForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});