/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of programs for approval in Dialog box.
 */
Ext.define('Academia.view.admission.applications.applicantProfileBase.ApproveRejectWithdrawAdmissionWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.approverejectwithdrawadmissionwindow',
    modal: true,
    resizable: false,
    admissionType:'',
    autoScroll: true,
    height: (Ext.isIE8) ? 600 : '65%',
    width: (Ext.isIE8) ? 600 : '70%',
    title: getAdmissionTranslation('APPROVE_ADMISSION'), //Approve Admission
    initComponent: function() {        
        var this$=this;
    	this.callParent(arguments);
        
        var window=this$;
        var grid=window.down('#admissionGrid');
        var submitButton=window.down('#submitBtn');
        var remarkItemId=window.down('#remarkItemId');
        var withdrawFromProgramBtn=window.down('#withdrawFromProgramBtn');
        if(!isEmpty(window) && !isEmpty(grid) && !isEmpty(submitButton)){
        	if (!isNullOrEmpty(this$.admissionType) && this.admissionType === 'APPROVE') {            	
            	window.setTitle(getAdmissionTranslation('APPROVE_ADMISSION'));  //Approve Admission
            	grid.setTitle(getAdmissionTranslation('SELECT_PROGRAM_APPROVE'));  //Select Program to be approve
            	submitButton.setText(getAdmissionTranslation('APPROVE'));  //Approve
            	remarkItemId.setFieldLabel(getAdmissionTranslation('ADMISSION_APPROVAL_REMARKS'));
            	window.down("#installmentRuleItemId").setVisible(true);
            	window.down("#allSectionsVerifiedItemId").setVisible(true);
            	window.down("#allDocumentsVerifiedItemId").setVisible(true);
            } else if (!isNullOrEmpty(this$.admissionType) && this.admissionType === 'REJECT') {
            	window.setTitle(getAdmissionTranslation('REJECT_ADMISSION'));  //Reject Admission
            	grid.setTitle(getAdmissionTranslation('SELECT_PROGRAM_REJECT'));  //Select Program to be Reject
            	submitButton.setText(getAdmissionTranslation('REJECT'));  //Reject
            	remarkItemId.setFieldLabel(getAdmissionTranslation('ADMISSION_REJECT_REMARKS'));
            } else if (!isNullOrEmpty(this$.admissionType) && this.admissionType === 'WITHDRAW') {
            	window.setTitle(getAdmissionTranslation('WITHDRAW_ADMISSION'));  //Withdraw Admission
            	grid.setTitle(getAdmissionTranslation('SELECT_PROGRAM_WITHDRAW'));  //Select Program to be Withdraw
            	submitButton.setText(getAdmissionTranslation('WITHDRAW'));  //Withdraw
            	remarkItemId.setFieldLabel(getAdmissionTranslation('ADMISSION_WITHDRAW_REMARKS'));
            	withdrawFromProgramBtn.setVisible(true);
            }
            this$.doLayout();
        }                                            
    },
    items: [{
        xtype: 'admissiongrid',
        itemId: 'admissionGrid'
    }, {
        xtype: 'approveadmissionprogramform',
        itemId: 'approveAdmissionProgramForm'
    }]
});
