/**
 *  Education History Grid
 */
Ext.define('Academia.view.admission.applications.applicantservice.ChekListItemGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.cheklistitemgrid',
	title : getPersonModuleTranslation('CHEKLIST_ITEMS'),
	border : true,
	autoScroll : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : [ {
		xtype : 'button',
		itemId : 'btnApplication',
		tooltip : getAdmissionTranslation('APPLICATION'),
		text :  getAdmissionTranslation('APPLICATION')
	}, {
		xtype : 'button',
		itemId : 'btnAdmission',
		tooltip : getAdmissionTranslation('ADMISSION'),
		text :  getAdmissionTranslation('ADMISSION')
	} ],
	columns : [  {
        header: getAdmissionTranslation('ACADEMY'), //Academy
        dataIndex: 'academy.value',
        sortable: true,
        flex: .2
    }, {
        header: getAdmissionTranslation('LOCATION'), //Location
        dataIndex: 'location.value',
        sortable: true,
        flex: .2
    }, {
        header: getAdmissionTranslation('PROGRAM'), //Program
        dataIndex: 'program.value',
        sortable: true,
        flex: .2
    }, {
        header: getAdmissionTranslation('BATCH'), //Batch
        dataIndex: 'batch.value',
        sortable: true,
        flex: .2
    }, {
        header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatType.value',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {    	     
     	var grid=this;
     	var store=Ext.create('Academia.store.admission.applicationFormSale.ApplicantSelectionSnapshotStore');
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }
     },
    dockedItems: [{
        xtype: 'toolbar',
        hidden:true,
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') 
        }]
    }]

});
