/**
 * Bulk Doc Download
 * @author deepak.mathur
 */
Ext.define('Academia.view.admission.applications.applicationBase.BulkDownloadDocumentWin', {
	extend : 'Ext.window.Window',
	alias : 'widget.bulkdownloaddocumentwin',
	title: getAdmissionTranslation('BULK_DOCUMENT_DOWNLOAD'),
	modal: true,
	//y: 100,
	style:{
    	height:'auto',
		width: 'auto'
    },
    resizable: true,
	items : [{
		xtype : 'form',
		height: 'auto',
		standardSubmit: false,
	    plugins: "formlabelrequired",
	    defaults:{
			labelAlign: 'top',
			width: 'auto'
		},
	items : [{
		xtype: 'customcombobox',
		fieldLabel: getAdmissionTranslation('USERNAME'),
		name:'user_name',
		itemId:'user_name',
		store: 'criteriabuilder.userquicksearch.QuickSearchName',
		msgTarget: 'qtip',
		valueField: 'id',
		displayField: 'valueCode',
		queryParam:'name',
		minChars:3,
		allowBlank: false,
		typeAhead:false,
        triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        enableKeyEvents  : 'true',
        hideTrigger:false,
        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        triggerAction: '',        
        forceSelection:true,
        readOnly:true,
        width: 200,
		  listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                    '</div>';
                }
            }
	},{
		xtype: 'multiselectcombofield',
		name: 'applicationDocumentsId',
		itemId: 'applicationDocumentsId',
		fieldLabel: getAdmissionTranslation('Document'),
		labelAlign: 'top',
		width: 180,
		height:30,
		//autoloadStore: false,
		store : 'admission.applications.applicationBase.BulkDocumentGroupStore',
		cls:'multiBrandCampusCls',
		displayField: 'documentName',
		valueField: 'id',
		maxLength:15000,
		allowBlank: false,
		listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				}
        }
	},{
		xtype:'fieldcontainer',
		items: [{
			xtype: 'radiogroup',
			itemId:'fileNameFormat',
			labelAlign:'top',
			fieldLabel: getAdmissionTranslation('FILE_NAME_FORMAT'),
			columns: 2,
			vertical: true,
			//allowBlank: false,
			style:{marginLeft:'-2px !important'},
			items: [
			        { boxLabel: getAdmissionTranslation('ID_FILE_NAME'), name: 'fileNameFormat', inputValue: getAdmissionTranslation('ID_FILE_NAME'),checked:true},
			        { boxLabel: getAdmissionTranslation('FILE_NAME_ID'), name: 'fileNameFormat', inputValue: getAdmissionTranslation('FILE_NAME_ID')}
			        ]
		},{
			xtype: 'radiogroup',
			itemId:'folderStructure',
			labelAlign:'top',
			fieldLabel: getAdmissionTranslation('FOLDER_STRUCTURE'),
			columns: 2,
			vertical: true,
			//allowBlank: false,
			style:{marginLeft:'-2px !important'},
			items: [
			        { boxLabel: getAdmissionTranslation('DOCUMENT_TYPE'), name: 'folderStructure', inputValue: getAdmissionTranslation('DOCUMENT_TYPE'),checked:true},
			        { boxLabel: getAdmissionTranslation('PERSON'), name: 'folderStructure', inputValue: getAdmissionTranslation('PERSON')}
			        ]
		}]
	},{
    	xtype:'fieldcontainer',
        items: [{
				xtype: 'button',
				formBind: true,
				text : getAdmissionTranslation('REQUEST_DOWNLOAD'),
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE    			
        	},{
    			xtype : 'button',
    			text : getCommonTranslation('CANCEL'),
    			itemId : 'bulkDocCancel',
    			ui : 'CustomBtnCancel',
    			scale : CONSTANTS.BUTTONSIZE
    		} ]
		}]
    }]
});
