/**
 * 
 */

Ext.define('Academia.view.admission.applications.applicationBase.DocumentStatusPopupGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.documentstatuspopupgrid',
	//title: getPersonModuleTranslation('LIST_OF_DOCUMENTS'),
	border : true,
	enableColumnHide : false,
	//autoScroll:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	dockedItems : [/*{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'admission.applications.applicationBase.OfferLetterDetailsStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}*/],
	columns: [{
    	header : getPersonModuleTranslation('DOCUMENTS_NAME'),
    	dataIndex : 'documentType',
    	itemId:'documentTypeItem',
    	sortable : true,
    	flex : .2,
    	renderer : function(value, metadata, record){
    		var msg = "";
    		if(!isNullOrEmpty(value)) {
    			msg = columnObjRender(value,"value");
    		}
    		return msg;
    	}
    },{
    	header : getPersonModuleTranslation('DOCUMENTS_TYPE'),
    	dataIndex : 'documentApplicability',
    	itemId:'documentApplicabilityItem',
    	sortable : true,
    	flex : .2,
    	renderer: function(obj) {
    		if(obj=='REQUEST_DOCUMENTS') {
    			return getCommonTranslation(obj);
    		} else {
    			return getAdmissionTranslation(obj);
    		}
    	}
    },{
    	header : getPersonModuleTranslation('DOCUMENT_UPLOADED_FROM'),
    	dataIndex : 'documentUploadedFrom',
    	itemId:'documentUploadedFrom',
    	sortable : true,
    	flex : .2,
    	renderer: function(obj) {
    		if(obj=='REQUEST_DOCUMENTS'){ 
    			return getCommonTranslation(obj);
    		}
    		else{
    			return getMegaMenuTranslation(obj);
    		}
    	}
    }, {
    	header : getPersonModuleTranslation('DATE_SUBMISSION'),
    	dataIndex : 'submissionDate',
    	sortable : true,
    	flex : .2,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header : getPersonModuleTranslation('RETURNED_DATE'),
    	dataIndex : 'returnedDate',
    	itemId:'returnedDateItem',
    	sortable : true,
    	flex : .2,
    	hidden:true,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header : getPersonModuleTranslation('MODE_SUBMISSION'),
    	dataIndex : 'modeOfSubmission',
    	sortable : true,
    	flex : .2,
    	renderer:function(value){
    		if(!isNullOrEmpty(value)){
    			value=getPersonModuleTranslation(value);
    		}else{
    			value='';
    		}
    		return value;
    	}
    }, {
    	header : getPersonModuleTranslation('INSPECTION_DATE'),
    	dataIndex : 'inspectionDate',
    	itemId:'inspectionDateItem',
    	sortable : true,
    	flex : .2,
    	hidden:true,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header : getPersonModuleTranslation('STATUS'),
    	dataIndex : 'documentStatusCSM',
    	sortable : true,
    	flex : .2,
    	renderer : function(value, metadata, record){
    		if(!isNullOrEmpty(value)){
    			if(value.code == 'PENDING' || value.code == 'PENDING_OPTIONAL'){
    				return '<span style="color:red;">' + "Pending" + '</span>';
    			}else{
    				return value.value;
    			}

    		}
    	}

    },{
    	header : getPersonModuleTranslation('PREVIEW'),
    	itemId: 'onlineDocGridPreviewBtn',
    	dataIndex: 'previewDoc',
    	flex : .2,
    	renderer: function(value, meta, record) {
        	if(isImageOrPDFDocument(record.data.path)){
           return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;" >'+getCommonTranslation('PREVIEW')+'</a>';
        	}
        	else{
        		return "-";
        	}
    	}
    	

    }],
    initComponent: function() {
        var this$ = this;
        //var store = this$.buildStore(this$.personType);
        var store = Ext.create('Academia.store.admission.applications.applicantdocuments.ApplicantAllDocumentStore');
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        //this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function(personType) {
    	return Ext.create('Academia.store.admission.applications.applicantdocuments.ApplicantAllDocumentStore'); 	        
    }
});