/**
 * @author Bhartendu Jain
 */
Ext.define('Academia.view.admission.applications.applicationBase.EligibilityDetailsForm', {
    extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.eligibilitydetailsform',
    border : false,
    frame : true,
    plugins: "formlabelrequired",
    title: getPersonModuleTranslation('ELIGIBILITY_DETAILS'),
    items: [{
        xtype: 'hidden',
        itemId: 'idItemId',
        name: 'id'
    }, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'achievementTypeId',
			itemId:'achievementTypeItemId',
			store:'admission.applications.eligibilitydetails.AchievementTypeStore',
			fieldLabel: getPersonModuleTranslation('ED_SCHOOL_LEAVING_CERTIFICATE_ACHIEVEMENT_TYPE'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			allowBlank:false,
            forceSelection: true,
            editable: false
		}, {
			xtype: 'textfield',
			name:'achievementTypeOther',
			itemId:'achievementTypeOtherItemId',
			fieldLabel: getPersonModuleTranslation('ED_SPECIFY_OTHERS'),
			allowBlank: true,
			hidden: true
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'progEndorsedStatusId',
			itemId:'progEndorsedStatusItemId',
			store:'admission.applications.eligibilitydetails.ProgEndorsedStatusStore',
			fieldLabel: getPersonModuleTranslation('ED_QUALIFICATION_ADMISSION_STATUS'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			allowBlank:true,
            forceSelection: true,
            editable: false
		}, {
			xtype: 'customcombobox',
			name: 'additionalReqMet',
			itemId:'additionalReqMetItemId',
			store: 'examinationcenters.YesNo',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank: true,
			fieldLabel: getPersonModuleTranslation('ED_ADDITIONAL_ADMISSION_REQUIREMENT_MET'),
            editable: false
		},{
			xtype: 'customcombobox',
			name:'heqsfLevelId',
			itemId:'heqsfLevelItemId',
			store:'admission.applications.eligibilitydetails.HEQSFLevelStore',
			fieldLabel: getPersonModuleTranslation('ED_HEQSF'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			allowBlank:true,
            forceSelection: true,
            editable: false
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'numberfield',
			name:'thirdYProgAvg',
			itemId:'thirdYProgAvgItemId',
			fieldLabel: getPersonModuleTranslation('ED_THIRD_YEAR_QUALIFICATION_AVERAGE'),
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
			allowBlank: true
		},{
			xtype: 'numberfield',
			name:'cognateSubAvg',
			itemId:'cognateSubAvgItemId',
			fieldLabel: getPersonModuleTranslation('ED_COGNATE_THIRD_YEAR_MODULE_AVERAGE'),
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
			allowBlank: true
		},{
			xtype: 'textfield',
			name:'honoursProgAvg',
			itemId:'honoursProgAvgItemId',
			fieldLabel: getPersonModuleTranslation('ED_HONOURS_QUAL_AVERAGE'),
			allowBlank: true
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'pgRequirementMet',
			itemId:'pgRequirementMetItemId',
			store: 'examinationcenters.YesNo',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank: true,
			fieldLabel: getPersonModuleTranslation('ED_POSTGRADUATE_CERTIFICATE_ADDITIONAL_REQUIREMENT_MET'),
            editable: false
		}, {
			xtype: 'customcombobox',
			name: 'pgMarks',
			itemId:'pgMarksItemId',
			store: 'examinationcenters.YesNo',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank: true,
			fieldLabel: getPersonModuleTranslation('ED_POSTGRADUATE_DIPLOMAS'),
            editable: false
		},{
			xtype: 'numberfield',
			name:'honoursProgMastersAvg',
			itemId:'honoursProgMastersAvgItemId',
			fieldLabel: getPersonModuleTranslation('ED_HONOURS_QUALIFICATION_AVERAGE_FOR_MASTERS'),
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
			allowBlank: true
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'numberfield',
			name:'mastersProgAvg',
			itemId:'mastersProgAvgItemId',
			fieldLabel: getPersonModuleTranslation('ED_MASTERS_QUALIFICATION_AVERAGE_FOR_DOCTORATE'),
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
			allowBlank: true
		},{
			xtype: 'customcombobox',
			name: 'rpl',
			itemId:'rplItemId',
			store: 'examinationcenters.YesNo',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			fieldLabel: getPersonModuleTranslation('ED_RPL'),
            editable: false
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'numberfield',
			name:'examNumber',
			itemId:'examNumberItemId',
			fieldLabel: getPersonModuleTranslation('ED_STUDENT_EXAMINATION_NUMBER'),
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
			allowBlank: true
		},{
			xtype: 'textfield',
			name:'examinationMonthAndYear',
			itemId:'examinationMonthAndYearItemId',
			fieldLabel: getPersonModuleTranslation('ED_EXAMINATION_MONTH_AND_YEAR'),
			allowBlank: true
		},{
			xtype: 'textfield',
			name:'province',
			itemId:'provinceItemId',
			fieldLabel: getPersonModuleTranslation('ED_PROVINCE'),
			allowBlank: true
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'textfield',
			name:'examBoard',
			itemId:'examBoardItemId',
			fieldLabel: getPersonModuleTranslation('ED_EXAMINATION_BOARD'),
			allowBlank: true
		},{
			xtype: 'numberfield',
			name:'centreNumber',
			itemId:'centreNumberItemId',
			fieldLabel: getPersonModuleTranslation('ED_EXAMINATION_CENTER_NUMBER'),
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
			allowBlank: true
		},{
			xtype: 'textfield',
			name:'centreName',
			itemId:'centreNameItemId',
			fieldLabel: getPersonModuleTranslation('ED_EXAMINATION_CENTER_NAME'),
			allowBlank: true
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'textfield',
			name:'attendanceMode',
			itemId:'attendanceModeItemId',
			fieldLabel: getPersonModuleTranslation('ED_ATTENDANCE_MODE'),
			allowBlank: true
		},{
			xtype: 'textfield',
			name:'heAdmissionOriginal',
			itemId:'heAdmissionOriginalItemId',
			fieldLabel: getPersonModuleTranslation('ED_HE_ADMISSION_ORIGINAL'),
			allowBlank: true
		},{
			xtype: 'textfield',
			name:'heAdmissionCombined',
			itemId:'heAdmissionCombinedItemId',
			fieldLabel: getPersonModuleTranslation('ED_HE_ADMISSION_COMBINED'),
			allowBlank: true
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'numberfield',
			name:'numberOfSubject',
			itemId:'numberOfSubjectItemId',
			fieldLabel: getPersonModuleTranslation('ED_NUMBER_OF_SUBJECT'),
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
			allowBlank: true
		},{
			xtype: 'customcombobox',
			name: 'achievedNSC',
			itemId:'achievedNSCItemId',
			store: 'examinationcenters.YesNo',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank: true,
			fieldLabel: getPersonModuleTranslation('ED_ACHIEVED_NSC'),
            editable: false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'eligibilityStatusId',
			itemId:'eligibilityStatusItemId',
			store:'admission.applications.eligibilitydetails.EligibilityStatusStore',
			fieldLabel: getPersonModuleTranslation('ED_ELIGIBILITY_STATUS'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			allowBlank:false,
            forceSelection: true,
            editable: false
		},{
			xtype: 'textarea',
			name: 'comment',
			itemId: 'commentItemId',
			fieldLabel: getPersonModuleTranslation('ED_REASON_COMMENT'),
			width: 460,
			enforceMaxLength : true,
			maxLength:250
		}]
	}, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }]
    }]
});