/**
 *  Vyabha Thakur
 */

Ext.define('Academia.view.admission.applications.applicationBase.MarkApplicationOffTrackWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.markapplicationofftrackwindow',
	modal: true,
    autoScroll:true,
    title: getCommonTranslation('MARK_APPLICATION_OFF_TRACK'),
    frame: true,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		method: 'POST',
	    autoScroll:true,
	    margin: 0,
	    bodyPadding: '10 10 10 10',
	    layout: 'anchor',
		defaults: {
			labelAlign: 'top',
			width : 226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype : 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{  
				xtype: 'hidden',
				name: 'id'
			},{	
				xtype:'radiogroup',
				itemId:'markApplicationOffTrackId',
				name: 'markApplicationOffTrack',
				items: [{
					boxLabel  : getCommonTranslation('LOST'),
					name      : 'markApplicationOffTrack',
					inputValue: true,
					checked   : true
				},{
					boxLabel  : getCommonTranslation('REAPPLIED'),
					name      : 'markApplicationOffTrack',
					inputValue: false,
					disabled  :  true
				}]
			}
			]
		},{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'markApplicationOffTrackReason',
				itemId: 'markApplicationOffTrackReason',
				fieldLabel: getCommonTranslation('LOST_REASON'),
				store:'admission.applications.applicantProfileBase.ReasonsForWithdrawalComboStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank:false
			}]
		},{
			layout : {
				type : 'hbox',
			},
			style:{
				marginLeft:'0px'
			},
			items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'saveBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
		}]
	}]
});