/**
 * @author Amandeep Bhatia
 */
Ext.define('Academia.view.admission.applications.applicationBase.ReviewDetailsPanel', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.reviewdetailspanel',
    refreshStoreData:true,
    store:'Academia.store.admission.applications.applicationReviewer.ApplicationReviewerDetailStore',
    title: getAdmissionTranslation('REVIEW_DETAILS'),
    border: true,
    refreshStoreData:true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}],
    columns: [ {
        header: getAdmissionTranslation('REVIEW_PARAMETER'),
        dataIndex: 'reviewParameter',
        menuDisabled: true,
        flex: 0.7,
        editor: {
            xtype: 'customcombobox',
            name: 'reviewParameterId',
            itemId: 'reviewParameterId',
            valueField: 'value',
            displayField:'value',
            forceSelection: true,
            enableKeyEvents : 'true',
            triggerAction: 'all',
            store:Ext.create('Academia.store.admission.applications.applicationReviewer.ReviewParamaterComboStore'),
            listeners: {
 				select: function(obj, record){
 					var grid = obj.up('grid');
 					var selectedRecord = grid.getSelectionModel().getSelection()[0];
 					if(!isNullOrEmpty(selectedRecord.data.id)){
 						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

 					}else{
 						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
 					}
 					recordToBeUpdated.set('reviewParameterId','');
 					var flag = true;
        			var itms = grid.getStore().data.items;
        			itms.forEach(function(object){
        				if(object.data.reviewParameterId  == record[0].data.id){
        					flag = false;
        					return false;
        				}
        			});
        			if(flag){
 					if(!isNullOrEmpty(selectedRecord.data.id)){
 						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

 					}else{
 						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
 					}
 					recordToBeUpdated.set('reviewParameterId',record[0].data.id);
 					return false;
        			}else{
        				obj.reset();
        				showWarningMessage(getCommonTranslation('ALERT'),getAdmissionTranslation('REVIEW_PARAMETER_ALREADY_SELECTED'));
        				return false;
        			}
 				}
        			
            }
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(record.data.reviewParameterId) && !isNullOrEmpty(value) && value !== '') {
        		return value;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
        		return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    },{
        header: getAdmissionTranslation('RATING'),
        dataIndex: 'reviewRating',
        menuDisabled: true,
        flex: 0.7,
        editor: {
            xtype: 'customcombobox',
            name: 'reviewRatingId',
            itemId: 'reviewRatingId',
            valueField: 'value',
            displayField:'value',
            forceSelection: true,
            store:Ext.create('Academia.store.admission.applications.applicationReviewer.ReviewRatingComboStore'),
            editable: false,
            listeners: {
 				focus: function(combo){ 
 					var grid = combo.up('reviewdetailspanel');
 					var selectedRecord = grid.getSelectionModel().getSelection()[0];
 					if(!isNullOrEmpty(selectedRecord.data.serialNo)){
 						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);
 					}
 					var reviewParameterId = recordToBeUpdated.data.reviewParameterId;
 					var store = combo.getStore();
 					store.on('beforeload', function(){
 						store.getProxy().extraParams = {
 							reviewParameterId:reviewParameterId
 						};
 					});
 					combo.getStore().load();
 					},
 					select: function(obj, record){
 	 					var grid = obj.up('grid');
 	 					var selectedRecord = grid.getSelectionModel().getSelection()[0];
 	 					if(!isNullOrEmpty(selectedRecord.data.id)){
 	 						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

 	 					}else{
 	 						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
 	 					}
 	 					recordToBeUpdated.set('reviewRatingId','');
 	 					var flag = true;
 	        			var itms = grid.getStore().data.items;
 	        			itms.forEach(function(object){
 	        				if(object.data.reviewRatingId  == record[0].data.id){
 	        					flag = false;
 	        					return false;
 	        				}
 	        			});
 	        			if(flag){
 	 					if(!isNullOrEmpty(selectedRecord.data.id)){
 	 						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

 	 					}else{
 	 						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
 	 					}
 	 					recordToBeUpdated.set('reviewRatingId',record[0].data.id);
 	        			}else{
 	        				obj.reset();
 	        				showWarningMessage(getCommonTranslation('ALERT'),getAdmissionTranslation('REVIEW_RATING_ALREADY_SELECTED'));
 	        				return false;
 	        			}
 	 				}
           }
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(record.data.reviewRatingId) && !isNullOrEmpty(value) && value !== '') {
        		return value;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
        		return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        	
        }
    },{
        header: getPersonModuleTranslation('REMARKS'),
        dataIndex: 'remarks',
        menuDisabled: true,
        flex: 0.7,
        editor: {
        	xtype: 'textfield',
			name: 'remarks',
			itemId:'remarks',
			maxLength : 1000
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 16px;max-height: 106px;min-width: 16ch;max-width: 17ch;';
		    		return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
				if(Ext.isDefined(record.get('remarks')) && isNullOrEmpty(record.get('remarks'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
        	}
        }
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        menuDisabled: true,
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        renderer: function(value, meta, record) {
            if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.reviewParameterId))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        menuDisabled: true,
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        		if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.reviewParameterId)) {
                    return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
                }	
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
    		beforeedit: function(editor, context) {
        		if(editor.context.field=='reviewParameter'){
        			if(!isNullOrEmpty(context.record.data.id)){
        				context.grid.columns[0].getEditor().setReadOnly(true);
        				return context.colIdx !== 0;
        			}else{
        				context.grid.columns[0].getEditor().setReadOnly(false);
        			}

        		}else if(editor.context.field=='reviewRating'){
        			if(!isNullOrEmpty(context.record.data.reviewRating)){
        				context.grid.columns[1].getEditor().setReadOnly(true);
        				return context.colIdx !== 1;
        			}else{
        				context.grid.columns[1].getEditor().setReadOnly(false);
        			}
        		}
        	}
    	}
    }],  getAllSelectedReviewParIds: function(combo){
    	var ids = [];
    	this.getStore().each(function(rec){
    		if(combo.getValue()!=rec.get('reviewParameterId') && !isNullOrEmpty(rec.get('reviewParameterId'))){
    			ids.push(rec.get('reviewParameterId'));
    		}
    	});
    	return ids.join();
    }
});
