Ext.define('Academia.view.admission.applications.applicationBase.SalesforceAdmissionDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.salesforceadmissiondetailsgrid',
	title: getCommonTranslation('SALESFORCE_ADMISSION_DETAILS'),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	tbar : [{
		xtype : 'button',
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls : 'view-icon'
	}],
	columns : [{
		header : getCommonTranslation('SALESFORCE_APPLICATION_ID'),
		dataIndex : 'salesForceApplication',
		sortable : true,
		flex : 1
	},{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('DELIVERY_MODE'),
		dataIndex : 'deliveryMode',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header: getCommonTranslation('SALESFORCE_APPLICATION_STAGE'), 
		dataIndex: 'salesForceStage',        
		flex: 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('ARTICULATION_AGREEMENT_NOTE'),
		dataIndex : 'articulationAgreementNote',
		flex : 1,
		renderer : function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				if(value.length > 50) {
					var splitValue = value.slice(0,50);
					metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(value) + '"';
					return splitValue;
				}
				else {
					return value;
				}
			}else{
				return "-";
			}
		}
	},{
		header : getCommonTranslation('ADMISSIONS_COMMENTS'),
		dataIndex : 'admissionComments',
		flex : 1,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
		if(!isNullOrEmpty(value)){
			if(value.length > 50) {
				var splitValue = value.slice(0,50);
				metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(value) + '"';
				return splitValue;
			}
			else {
				return value;
			}
		}	
		}
	
	},{
		header : getCommonTranslation('DIRECT_ENTRY'),
		dataIndex : 'isDirectEntry',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value) && value == true){
				return 'Yes';
			}else{
				return 'No';
			}
		}
	},{
		header : getCommonTranslation('TRANSFER'),
		dataIndex : 'isTransferCase',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value) && value == true){
				return 'Yes';
			}else{
				return 'No';
			}
		}
	},{
		header : getCommonTranslation('LATE_ARRIVAL'),
		dataIndex : 'isLateArrival',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value) && value == true){
				return 'Yes';
			}else{
				return 'No';
			}
		}
	},{
		header : getCommonTranslation('SUB_PROGRAM_1'),
		dataIndex : 'subProgram1',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('SUB_PROGRAM_2'),
		dataIndex : 'subProgram2',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('SCHOLARSHIP_NAME'),
		dataIndex : 'scholarshipName',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('SCHOLARSHIP_DURATION'),
		dataIndex : 'scholarshipDuration',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header: getCommonTranslation('VERTICAL_AREA_IN_SALESFORCE'), 
		dataIndex: 'verticalArea',        
		flex: 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('COUNTRY_OF_RECRUITMENT'),
		dataIndex : 'countryName',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('APPLICANT_PORTAL_CONTACT'),
		dataIndex : 'applicantPortalContact',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('EC_COMMISSION_ACCOUNT'),
		dataIndex : 'ecCommissionAccount',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('APPLICATION_OWNER'),
		dataIndex : 'applicationOwner',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}else{
				return '-';
			}
		}
	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
    		return Ext.create('Academia.store.admission.applicationFormSale.SalesforceAdmissionDetailsStore');
    }
});