Ext.define('Academia.view.admission.applications.applicationBase.TransferCreditsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.transfercreditsgrid',
    title: getCommonTranslation('LIST_OF_COURSES'),
    border: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selType:'checkboxmodel',
    plugins: {
    	ptype: 'cellediting',
        clicksToEdit: 1
    },
    height:400,
   /* getGradeMasterForCourse: function(courseId) {
        return [
            { id: 1, value: 'A' },
            { id: 2, value: 'B' },
            { id: 3, value: 'C' }
        ];
    },*/
    autoScroll:true,
    selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
    tbar: [{
    	xtype: 'button',
		itemId: 'approveATCBtnitemId',
		disabled:true,
		tooltip: getCommonTranslation('APPROVE'),
		text: getCommonTranslation('APPROVE'),
    },{
    	xtype: 'button',
		itemId: 'rejectATCBtnitemId',
		disabled:true,
		tooltip: getCommonTranslation('REJECT'),
		text: getCommonTranslation('REJECT'),
    },{
    	xtype: 'button',
		itemId: 'resubmitATCBtnitemId',
		disabled:true,
		tooltip: getCommonTranslation('RESUBMIT'),
		text: getCommonTranslation('RESUBMIT'),
    }],

    columns: [{
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'programPeriodName',
        flex: 1,
    },{
        header: getCommonTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        flex: 1
    },{
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex: 1
    }, {
        header: getCommonTranslation('CREDITS'),
        dataIndex: 'courseCredits',
        flex: 0.5
    }, {header: getCommonTranslation('MARKS_OR_GRADE'),
        dataIndex: 'gradeType',
        flex: 1,

        getEditor: function(record) {
            var courseGradeType = record.get('courseGradeType')
            var type = record.get('courseType');

            if (type === 'G') {
                var gradeStore = Ext.create('Ext.data.Store', {
                    fields: ['gradeType', 'id', 'value', 'doubleValue'],
                    proxy: {
                        type: 'ajax',
                        url: SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_GRADE_DROP_DOWN,
                        extraParams: {
                            gradeType: courseGradeType
                        },
                        reader: {
                            type: 'json',
                            root: 'data'
                        }
                    },
                    autoLoad: false
                });
                return Ext.create('Ext.grid.CellEditor', {
                    field: Ext.create('Ext.form.field.ComboBox', {
                        name: 'finalGrade',
                        store: gradeStore,
                        valueField: 'value',
                        displayField: 'value',
                        editable: false,
                        listeners: {
                            expand: function() {
                                if (!isNullOrEmpty(gradeStore)) {
                                    gradeStore.load();
                                }
                            },
                            select: function(combo, records) {
                            	record.set('gradeType', records[0].get('value'));
                                record.set('doubleValue', records[0].get('doubleValue'));
                            }
                        }
                    })
                });
            }
            if(type === 'M'){
                {
                    return Ext.create('Ext.grid.CellEditor', {
                        field: Ext.create('Ext.form.field.Number', {
                            name: 'totalMarks',
                            maxLength: 99,
                            minValue: 0,
                            maxValue: 100,
                            decimalPrecision: 4,
                            allowDecimals: true,
                            mouseWheelEnabled: false
                        })
                    });
                }
            }

            return null;
        },

        renderer: function (value, meta, rec) {
            if (isNullOrEmpty(value)) {
                meta.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            }
            return value;
        }}, {
        header: getCommonTranslation('EQUIVALENT_COURSE_CODE'),
        dataIndex: 'equivalenceCourseCode',
        flex: 1,
        editor: {
			xtype: 'textfield',
			name: 'equivalenceCourseCode',
			itemId: 'equivalenceCourseCodeItemId',
			maxLength: 99,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			allowBlank: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
    }, {
        header: getCommonTranslation('EQUIVALENT_COURSE_NAME'),
        dataIndex: 'equivalenceCourseName',
        flex: 1,
        editor: {
			xtype: 'textfield',
			name: 'equivalenceCourseName',
			itemId: 'equivalenceCourseNameItemId',
			maxLength: 99,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			allowBlank: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
    }, {
        header: getCommonTranslation('INSTITUTE_NAME'),
        dataIndex: 'institueName',
        flex: 1,
        editor: {
			xtype: 'textfield',
			name: 'institueName',
			itemId: 'institueNameItemId',
			maxLength: 99,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
    }, {
        header: getCommonTranslation('EQUIVALENT_COURSE_CREDIT'),
        dataIndex: 'equivalenceCourseCredit',
        flex: 1,
        editor: {
			xtype: 'numberfield',
			name: 'equivalenceCourseCredit',
			itemId: 'equivalenceCourseCreditItemId',
			minValue: 0,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
    }, {
        header: getCommonTranslation('OBTAINED_MARKS_GRADES'),
        dataIndex: 'obtainedMarkGrade',
        flex: 1,
        editor: {
			xtype: 'textfield',
			name: 'obtainedMarkGrade',
			itemId: 'obtainedMarkGradeItemId',
			maxLength: 99,
			enforceMaxLength: true,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals: false
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
    }, {
        header: getCommonTranslation('STATUS'),
        dataIndex: 'applicantTransferCreditStatus',
        flex: 1,
        renderer: function(value) {
            if (value === 'APPROVE') {
                return getCommonTranslation('APPROVED');
            } else if (value === 'PENDING') {
                return getCommonTranslation('PENDING');
            } else if (value === 'REJECT') {
                return getCommonTranslation('REJECTED');
            } else if (value === 'NEED_TO_RESUBMIT') {
                return getCommonTranslation('NEED_TO_RESUBMIT');
            } else if (value === 'SUBMIT') {
                return getCommonTranslation('SUBMIT');
            }else if (value === 'PENDING') {
                return getCommonTranslation('PENDING');
            } else {
                return value || '';
            }
        }
    }, {
        header: getCommonTranslation('APPLICANT_REMARKS'),
        dataIndex: 'applicantRemark',
        flex: 1,
        editor: {
			xtype: 'textfield',
			name: 'applicantRemark',
			itemId: 'applicantRemarkItemId',
			maxLength: 255,
			enforceMaxLength: true,
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
    },{
        header: getCommonTranslation('FACULTY_REMARKS'),
        dataIndex: 'facultyRemark',
        flex: 1,
        editor: {
			xtype: 'textfield',
			name: 'facultyRemark',
			itemId: 'facultyRemarkItemId',
			maxLength: 255,
			enforceMaxLength: true,
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
    }, {
        header: getCommonTranslation('COMPLETION_DATE'),
        dataIndex: 'completionDate',
        flex: 1,
        editor: {
			xtype: 'datefield',
			name: 'completionDate',
			itemId: 'completionDate',
			maxValue: new Date()
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return Ext.Date.format(new Date(val), 'd-m-Y');;
			}
		}
    
    },{
        header: getCommonTranslation('APPROVER_NAME'),
        dataIndex: 'approverBy',
        flex: 1,
//        editor: {
//			xtype: 'textfield',
//			name: 'approverName',
//			itemId: 'approverNameItemId',
//			readOnly: true
//		}
    },{
        header: getCommonTranslation('APPROVE_REJECT_DATE'),
        dataIndex: 'approveRejectDate',
        flex: 1,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                var date = new Date(value);
                return Ext.Date.format(date, 'd-m-Y');
            }
            return '';
        }
    },{
    	header: getCommonTranslation('EQUIVALENT_COURSE_SYLLABUS'),
        dataIndex: 'document',
        flex: 1,
        renderer: function(val, meta, rec) {
            
            var uploadIcon = '<span class="upload-icon-v2" style="margin-right:5px"><input type="file" style="opacity:0;width:22px;cursor:pointer;" class="grid-upload-input"/></span>';
            var downloadIcon = '<span class="download-icon-v2" data-doc-path="' + (rec.get('document') || '') + '" style="cursor:pointer;"></span>';
 
            return '<div class="upload-download-wrapper" style="display:flex">' + uploadIcon + downloadIcon + '</div>';
        }
    }],

    initComponent: function() {
    	  var this$ = this;
          var store = this$.buildStore();
          Ext.apply(this$, {
              store: store,
              dockedItems: [{
                  xtype: 'toolbar',
                  dock: 'bottom',
                  items: [{
                      xtype: 'custompagingtoolbar',
//                      plugins: ['pagesize'],
                      store: store,
                      emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                      displayInfo: true
                  }]
              }]
          });
          this$.addExportToolBarItems(this$);
          this$.callParent(arguments);
          
          /*this.plugins[0].on('beforeedit', function(editor, e) {
        	    if (e.field === 'courseMarksGrades') {
        	        var record = e.record,
        	            markType = record.get('markType'),
        	            gradeType = record.get('gradeType');

        	        if (!isNullOrEmpty(gradeType)) {
        	            e.column.setEditor(Ext.create('Ext.form.ComboBox', {
        	                store: Ext.create('Ext.data.Store', {
        	                    fields: ['id', 'value'],
        	                    data: getGradeMasterForCourse(record.get('courseId'))
        	                }),
        	                queryMode: 'local',
        	                displayField: 'value',
        	                valueField: 'value',
        	                editable: false,
        	                forceSelection: true,
        	                allowBlank: true
        	            }));
        	        } else if (!isNullOrEmpty(markType)) {
        	            e.column.setEditor(Ext.create('Ext.form.TextField', {
        	                allowBlank: true,
        	                maxLength: 10
        	            }));
        	        } else {
        	            e.cancel = true; // Cancel editing if no type found
        	        }
        	    }
        	});*/
    },

    buildStore: function() {
        return Ext.create('Academia.store.admission.applications.applicantTransferCredits.AllApplicantTransferCreditDetailStore');
    },
    
});
