/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show fee plans for applied programs in grid.  
 */
Ext.define('Academia.view.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionFeePlansGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.preadmissionfeeplansgrid',
    title: getAdmissionTranslation('FEE_PLANS_APPLIED_PROGRAMS'), //Fee Plans for Programs Applied	    
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },        
    initComponent: function() {    	     
     	var grid=this;
     	var store=Ext.create('Academia.store.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionFeePlanGridStore');
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }
     },
    columns: [{
      /*  header: getAdmissionTranslation('PREF_SEQ'), //Pref. Seq.
        dataIndex: 'prefSeq',
        flex: .2
    }, {*/
        header: getAdmissionTranslation('ACADEMY'), //Academy
        dataIndex: 'academyName',
        flex: .2
    }, {
        header: getAdmissionTranslation('LOCATION'), //Location
        dataIndex: 'locationName',
        flex: .2
    }, {
        header: getAdmissionTranslation('PROGRAM'), //Program
        dataIndex: 'programName',
        flex: .2        
    }, {
        header: getAdmissionTranslation('BATCH'), //Batch
        dataIndex: 'batchName',
        flex: .2
    }, {
        header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatType',
        flex: .2
    }, {
        header: getAdmissionTranslation('FEE_PLAN'), //Fee Plan
        dataIndex: 'feePlanName',
        flex: .2        
    }, {
        header: getAdmissionTranslation('RULE'), //Sequence
        dataIndex: 'sequence',
        flex: .2        
    }, {
        header: getAdmissionTranslation('SEQUENCE_RULE_DESC'), //Sequence Rule Description
        dataIndex: 'sequenceRuleDesc',
        flex: .2        
    }, {
        header: getAdmissionTranslation('NUMBER_OF_FEE_HEADS'), 
        dataIndex: 'noOfFeeHeads',
        flex: .2,
        renderer: function(value) {
        	if(!isNullOrEmpty(value) && value !=0)
            	   value="<a href='#'>"+value+"</a>";
            return value;
        }
    }],    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')        
        }]
    }]
});
