/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of Applicant Details in grid  
 */
Ext.define('Academia.view.admission.assignApplicationID.AssignApplicationIDGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.assignapplicationidgrid',
    store: 'admission.assignApplicationID.AssignApplicantStore',
    title: getAdmissionTranslation('LIST_OF_APPLICANTS'), //List of Applicants	
    plugins: [{
        ptype: 'rowexpander',
        pluginId: 'applicantRowExpander',
        rowBodyTpl: new Ext.XTemplate('<td colspan="5"><table style="border:1px solid black;">', 
        			'<tr>', 
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('ACADEMY') + '</th>',
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('LOCATION') + '</th>', 
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('PROGRAM') + '</th>', 
        				//'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('BATCH') + '</th>', 
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('SEAT_TYPE') + '</th>', 
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEES_AMOUNT') + '</th>',
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEES_PLAN') + '</th>',
        				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('RECEIPT_NO') + '</th>',
        			'</tr>',
        			'<tpl for=".">',
        			'<tr>', 
        				'<td style="width:100px;text-align:center">{academy}</td>',
        				'<td style="width:100px;text-align:center">{location}</td>', 
        				'<td style="width:100px;text-align:center">{program}</td>', 
        				//'<td style="width:100px;text-align:center">{batch}</td>',
        				'<td style="width:100px;text-align:center">{seatType}</td>',
        				'<td style="width:100px;text-align:center">{feeAmount}</td>',
        				'<td style="width:100px;text-align:center">{feePlan}</td>',
        				'<td style="width:100px;text-align:center">{receiptNo}</td>',         				
        			'</tr>', 
        			'</tpl>',
        		'</table></td>')
    }],
    border: true,    
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    /*features: [{
        ftype: 'summary',
        dock: 'bottom'
    }],*/
    columns: [{
        header: getAdmissionTranslation('APPLICANT_NAME'), //Applicant Name
        dataIndex: 'applicantName',
        flex: .1
    },{
        header: getAdmissionTranslation('APPLICATION_ID'), //Application ID
        dataIndex: 'applicationId',
        flex: .1
    },{
        header: getAdmissionTranslation('COLLECTED_BY_PHONE_NUMBER'), 
        dataIndex: 'applicationForm',
        flex: .2,
        renderer : function(value,record){
        	if(!isNullOrEmpty(value)){
        		if(!isNullOrEmpty(value.collectedByCountryCode)){
        			return value.collectedByCountryCode+"-"+value.collectedByPhoneNo;;
        		}else{
        			return value.collectedByPhoneNo;
        		}/*if(!isNullOrEmpty(value.collectedByCountryCode) && !isNullOrEmpty(value.collectedByPhoneNo)){
        			return value.collectedByCountryCode +"-"+value.collectedByPhoneNo;
        		}*/
        	}
        }
    },{
        header: getAdmissionTranslation('COLLECTED_BY_LANDLINE_NUMBER'), 
        dataIndex: 'applicationForm',
        flex: .2,
        renderer : function(value,record){
        	if(!isNullOrEmpty(value)){
        		var collectedByLLCountryCode='', collectedByLLAreaCode='', collectedByLandlineNo='';
        		
        		if(value.collectedByLLCountryCode){
        			collectedByLLCountryCode = value.collectedByLLCountryCode.concat("-");
        		}
        		if(value.collectedByLLAreaCode){
        			collectedByLLAreaCode = value.collectedByLLAreaCode.concat("-");
        		}
        		if(value.collectedByLandlineNo){
        			collectedByLandlineNo = value.collectedByLandlineNo;
        		}
        		return collectedByLLCountryCode + collectedByLLAreaCode + collectedByLandlineNo;
        	}		
        }
    },{
        header: getAdmissionTranslation('COLLECTED_BY_EMAIL'), 
        dataIndex: 'applicationForm.collectedByEmail',
        flex: .2
    },{
        header: getAdmissionTranslation('COLLECTED_BY_ADDRESS'),
        dataIndex: 'applicationForm.collectedByAddress',
        flex: .2
    }],
    tbar: [{
        xtype: 'textfield',
        itemId: 'txtReceiptNo',
         //Receipt NO.
        fieldLabel: getAdmissionTranslation('RECEIPT_NO') //Receipt NO.
    },{
        xtype: 'textfield',
        itemId: 'txtTokenId',
         //Token ID
        fieldLabel: getAdmissionTranslation('TOKEN_ID') //Token ID
    },{
        xtype: 'button',
        itemId: 'btnFindApplication',        
        disabled:true,
        tooltip: getAdmissionTranslation('FIND_APPLICANT'), //Find Applicant
        text: getAdmissionTranslation('FIND_APPLICANT') //Find Applicant
    },{
        xtype: 'button',
        itemId: 'assignApplicationId',   
        tooltip: getAdmissionTranslation('ASSIGN_APP_ID'), //Assign Application ID
        text: getAdmissionTranslation('ASSIGN_APP_ID'), //Assign Application ID
    },{
        xtype: 'button',
        itemId: 'makePayment',    
        tooltip: getAdmissionTranslation('COLLECT_PAYMENT'), //Make Payment
        text: getAdmissionTranslation('COLLECT_PAYMENT'), //Make Payment
    }, 
    /*{
        xtype: 'splitbutton',
        text: getCommonTranslation('MOREACTIONS'),
        itemId: 'btnMoreOperations',
        disabled:true,
        tooltip: getCommonTranslation('MOREACTIONS'),
        menu: new Ext.menu.Menu({
            items: [{
                text: getAdmissionTranslation('ASSIGN_APP_ID'), //Assign Application ID
                itemId: 'assignApplicationId'
            },{
                text: getAdmissionTranslation('MAKE_PAYMENT'), //Make Payment
                itemId: 'makePayment'
            }]
        })
    }*/
    ],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            store: 'admission.assignApplicationID.AssignApplicantStore',
            doRefresh : function(){
                // Keep or remove these code
                var me = this,
                    current = me.store.currentPage;

                if (me.fireEvent('beforechange', me, current) !== false) {
                    me.store.loadPage(current);
                }
                
                var assignapplicationidgrid = me.up('assignapplicationidgrid');
                if(assignapplicationidgrid != undefined && assignapplicationidgrid != null){
                	var plugins = assignapplicationidgrid.plugins;
                	if(plugins != undefined && plugins != null && plugins.length > 0){
                		rowExpander = plugins[0];
                		for (i = 0; i < assignapplicationidgrid.getStore().getTotalCount(); i++) {                    		
                    		rowNode = rowExpander.view.getNode(i),
                            row = Ext.fly(rowNode, '_rowExpander');
                    		if(row != undefined ){
                    			if(!row.hasCls(rowExpander.rowCollapsedCls)){
                    				rowExpander.toggleRow(i, assignapplicationidgrid.getStore().getAt(i));
                    			}
                    		}
                        }
                	}
                }
                //alert("Refresh called");
             }
        }]
    }]
});
