/**
 * this window is used to show the quota validity form on the quota validity grid.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.quotas.QuotaValidityWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.quotavaliditywindow',
	modal : true,
	resizable : false,
	margin : 0,
	title : getAdmissionTranslation('QUOTA_VALIDITY'),// quota Details
	items : [ {
		xtype : 'form',
		itemId : 'validityForm',
		standardSubmit : false,
		defaults: {
            labelAlign: 'top',
            width: 226
        },
		plugins : "formlabelrequired",
		items : [{
	        xtype: 'hidden',
	        fieldLabel: 'Id',
	        name: 'id'
	    },{
			xtype : 'hidden',
			fieldLabel: getAdmissionTranslation('QUOTA_ID'),
			name: 'quotaId'
		},{
			xtype : 'datefield',
			name : 'validFrom',
			fieldLabel : getCommonTranslation('VALID_FROM'),// quota type
			itemId : 'validFrom',
			//--submitFormat: CONSTANTS.DATE_FORMAT,
//			format:  CONSTANTS.DATE_FORMAT,
			allowBlank: false,
			vtype: 'daterange',
			endDateField:'validTill',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}, {
			xtype : 'datefield',
			name : 'validTill',
			fieldLabel : getCommonTranslation('VALID_TILL'),// quota type
			itemId : 'validTill',
			//--submitFormat: CONSTANTS.DATE_FORMAT,
//			format:  CONSTANTS.DATE_FORMAT,
			allowBlank: false,
			vtype: 'daterange',
			startDateField:'validFrom',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
            xtype: 'statusCombo',
            allowBlank: false,
            editable: false,
            name: 'status',
            value:true 
        }, {
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				itemId : 'btnSaveQuotaValidity',
				text : getCommonTranslation('SAVE'), // Submit
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
		} ]
	} ]

});
