/**
 * this window is used to show the conditional marks form on the conditional marks grid
 * which is in the "Stage Configuration" tab of the Selection process.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.ConditionalMarksWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.conditionalmarkswindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getAdmissionTranslation('CONDITIONAL_MARKS'), 
    items: [{
        xtype: 'form',
        itemId: 'evalParamForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id'
        },{
        	xtype : 'hidden',
        	name: 'version'
        }, {
			xtype : 'textfield',
			name : 'ruleName',
			fieldLabel : getExaminationTranslation('RULE_NAME'),
			allowBlank: false
        }, {
			xtype : 'numberfield',
			name : 'marks',
			fieldLabel : getAdmissionTranslation('MARKS'),
			allowBlank: false,
			minValue: 0,
			maxValue: 100,
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false
        },{
            xtype: 'textfield',
            name: 'rule',
            fieldLabel: getAdmissionTranslation('RULE'), 
            allowBlank: false
        },{
            xtype: 'textarea',
            name: 'ruleDescription',
            fieldLabel: getAdmissionTranslation('RULE_DESCRIPTION')
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveConditionalMarks',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function() {
                        this.up('window').close(); 
                    }
                }
            }]
        }]
    }]

});