/**
 * This Grid is used for Evaluation Parameters of the Selection Process tab of selection process.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.EvaluationParametersGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.evaluationparametersgrid',
	title : getAdmissionTranslation('EVALUATION_PARAMETERS'),
	collapsible: true,
	border : true,
	store: 'Academia.store.admission.selectionProcess.EvaluationParameters',
	
	columns : [ {
		text : getAdmissionTranslation('EVALUATION_PARAMETER'),
		dataIndex: 'evaluationParameter',
		sortable : true,
		flex : .5
	}, {
		text : getAdmissionTranslation('WEIGHTAGE'),
		dataIndex : 'weightage',
		sortable : true,
		flex : .2
	}, {
		text : getAdmissionTranslation('MAXIMUM_MARKS'),
		dataIndex : 'maxMarks',
		sortable : true,
		flex : .3
		
	}, {
		text : getAdmissionTranslation('MINIMUM_MARKS'),
		dataIndex : 'minMarks',
		sortable : true,
		flex : .3
		
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	 emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
			store : 'Academia.store.admission.selectionProcess.EvaluationParameters'
        }]
    }],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}]
});