/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.selectionStageReport.SelectionStageReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.selectionstagereportfilter',
	autoScroll:false,
	
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'panel',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
	            xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
	            name: 'ACAD_LOC_ID',
	            itemId:'academyLocationCombo',
	            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
	            displayField: 'value',
	            valueField: 'id',
	            typeAhead : true,
	            forceSelection:true,
	            hideTrigger:false,
	            queryParam:'qry',
	            allowBlank:false,
	    	    triggerAction: 'all',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								var selectionstagereportSearchField = Ext.ComponentQuery.query('selectionstagereportfilter')[0];
								if(isNullOrEmpty(selectionstagereportSearchField.down('#programId').getValue()))
									{
									selectionstagereportSearchField.down('#searchFilterBtn').setDisabled(true);	
									}
								
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	        },{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('PROGRAM'), //Program
				name: 'PROGRAM',
				itemId: 'programId',
				autoload: false,
				allowBlank:false,
				store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'qry',
				typeAhead : true,
	            forceSelection:true,
	            disabled:true,
	            hideTrigger:false,
	            triggerAction: 'all',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								var selectionstagereportSearchField = Ext.ComponentQuery.query('selectionstagereportfilter')[0];
								if(isNullOrEmpty(selectionstagereportSearchField.down('#batchId').getValue()))
								{
								selectionstagereportSearchField.down('#searchFilterBtn').setDisabled(true);
								}
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
				name: 'BATCH',
				itemId: 'batchId',
				editable: false,
				autoload: false,
				allowBlank:false,
				store: Ext.create('Academia.store.common.BatchesByProgramId'),
				disabled:true,
				valueField: 'id',
				displayField: 'value',
				queryMode : 'local'
			},{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
				name: 'progBatchSeatConfId',
				itemId: 'seatTypeId',
				editable: false,
				autoload: false,
				allowBlank:false,
				store: Ext.create('Academia.store.common.SeatTypesByBatchId'),
				disabled:true,
				valueField: 'id',
				displayField: 'seatTypeName',
				queryMode : 'local'
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchFilterBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});
