/**
 *  @author Amit Gupta
 * 
 */
Ext.define('Academia.view.alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.alumnicommunicationhistoryfilter',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},		
        items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('ALUMNI_ID_NAME'),
				name: 'alumniIdName',
	            itemId: 'alumniNameIdItemId',
	            minChars:3,
				forceSelection:true,
				store: 'alumni.alumniList.AlumniIDNameStore',
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'id',
				displayField: 'code',
				queryParam:'code',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
    			xtype: 'customcombobox',
				fieldLabel:getAlumni('EMAIL_ID'),
				name: 'alumniEmail',
				itemId:'alumniEmailItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.alumniList.AlumniEmailIdStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'emailId',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
    			xtype: 'customcombobox',
				fieldLabel:getAlumni('NOTIFICATION_TYPE'),
				name: 'notificationType',
				itemId:'notificationTypeItemId',
				forceSelection:true,
				store: 'alumni.alumniList.AlumniNotificationStore',
				valueField: 'id',
				displayField: 'value',
				listConfig: {
					listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
				}
			}/*,{
    			xtype: 'customcombobox',
				fieldLabel:getAlumni('SENT_BY'),
				name: 'sentBy',
				itemId:'sentByItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.alumniList.AlumniEmailIdStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'emailId',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			}*/],			
    	},{
    		xtype: 'fieldcontainer',    
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},	
    		items: [{
    			xtype: 'datefield',
    			fieldLabel: getAlumni('START_DATE'),
    			name: 'startDate',
    			itemId: 'startDateItemId',
    			allowBlank:false,
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat: CONSTANTS.DATE_FORMAT,
    			vtype: 'daterange',
    			endDateField: 'endDateItemId',
    			editable:false,
    		}, {
    			xtype: 'datefield',
    			fieldLabel: getAlumni('END_DATE'),
    			name: 'endDate',
    			itemId: 'endDateItemId',
    			allowBlank:false,
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat: CONSTANTS.DATE_FORMAT,
    			vtype: 'daterange',
    			startDateField: 'startDateItemId',
    			editable:false,
    		}]		
    	},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'submitBtn',
    			itemId : 'submitBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'resetBtnItemId',
    			name: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	}]
});

