/**
 *  @author Harshit Satya
 */

Ext.define('Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsRaisingGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.alumnifundsraisinggrid',
    store: 'alumni.alumniFundsRaising.AlumniFundsRaiseFilterStore',
    title: getAlumni('FUND_RAISING_LIST'),
    selType:'checkboxmodel',
    autoScroll:true,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
	},
    border: true,
    refreshStoreData: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
    },
    cls:'mb-40',
    headerFix: {
    	headerFix: true,
    	portalIdsWithStructure: {
			'alumnifundsraisingstructure':1
		}
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'alumni.alumniFundsRaising.AlumniFundsRaiseFilterStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
            isGridConfigurable: true, 
    	    enableColumnHide: false,
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		disabled:true,
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'btnViewTransactions',
		disabled:true,
		tooltip: getAlumni('VIEW_TRANSACTIONS'),
		text: getAlumni('VIEW_TRANSACTIONS'),
	},'->'],
    columns: [{
        header: getAlumni('IMAGE'),
        dataIndex: 'imageUrl',
        flex: 1,
        renderer: function(value, metaData) {metaData.tdAttr = 'type="gridImageCell"';
        if(!isNullOrEmpty(value) && value !=0){
            var extensionArr = value.split(".");
            var imageUrl="resources/images/uploads/"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
            value = '<img src="' + imageUrl + '?' + Date.now() + '" height="50" width="50" ' +'style="margin: 0 auto; display: block; border-radius: 50%;">';
            return value;
        }else{
            var imageUrl="resources/images/Avatar_place_holder.svg";
            value = '<div class="containerBox">'
                    + '<div class="avtar-containerBox" style="display: inline-block; vertical-align: middle;">'
                    +'<img style="border-radius: 100px;" src="'+imageUrl+'?'+ Date.now()+'" height="40" width="40" alt="Round Image">'
                    +'</div>'
                    + '</div>'
            return value;
       }}
    }, {
        header: getCommonTranslation('FUND_ID'),
        dataIndex: 'fundsCode',
        flex: 1
    }, {
        header: getAlumni('TITLE'),
        dataIndex: 'fundsTitle',
        flex: 1
    }, {
        header: getAlumni('DESCRIPTION'),
        dataIndex: 'description',
        flex: 2
    }, {
        header: getAlumni('START_DATE'),
        dataIndex: 'alumniStartDate',
        flex: 1
    }, {
        header: getAlumni('END_DATE'),
        dataIndex: 'alumniEndDate',
        flex: 1
    }, {
        header: getAlumni('CURRENCY'),
        dataIndex: 'currencyName',
        flex: 1
    }, {
        header: getCommonTranslation('DONATION_GOAL'),
        dataIndex: 'donationGoal',
        flex: 1,
        renderer: Ext.util.Format.numberRenderer('0,0.00')
    }, {
        header: getAlumni('STATUS'),
        dataIndex: 'status',
        flex: 1,
		renderer:function(value) {
			return value == true ? 'Active' : 'Inactive';
		}
    }]
});
