/**
 *  @author Niklesh T
 * 
 */
Ext.define('Academia.view.alumniSystem.signUpRequest.SignUpRequestDetails',{
	extend: 'Ext.form.Panel',
	alias : 'widget.signUpRequestDetails',
	cls:'horizontalScrollingFixed',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:true,
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
	},	
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},		
        items: [{
					xtype: 'hidden',
					fieldLabel:getAlumni('REQUEST_ID'),
					name: 'requestHiddenID',
					itemId:'requesHiddentItemId'
		        },{
				xtype: 'textfield',
				fieldLabel:getAlumni('REQUEST_ID'),
				name: 'requestID',
				itemId:'requestItemId'
	        },{
				xtype: 'textfield',
				fieldLabel:getAlumni('FIRST_NAME'),
				name:'requestFirstName',
				itemId:'requestFirstItemId'
			},{
				xtype: 'textfield',
				fieldLabel:getAlumni('MIDDLE_NAME'),
				name:'requestMidName',
				itemId:'requestMidNameItemId'
			}]
		},{
		        xtype: 'fieldcontainer',
		        width : '100%',
				layout: {
					type : 'hbox'
				},
				defaults: {
					width: 226,
					labelAlign: 'top'
				},		
		        items: [{
					xtype: 'textfield',
					fieldLabel:getAlumni('LAST_NAME'),
					name:'requestLastName',
					itemId:'requestLastNameItemId'
				},{ 
					xtype : 'textfield',
					fieldLabel : getAlumni('MOBILE_NUMBER'),		
					name : 'requestMobileNumber',
					itemId : 'requestMobileItemId'
				},{
					xtype : 'textfield',
					fieldLabel : getAlumni('EMAIL_ID'),		
					name : 'requestEmailId',
					itemId : 'requestEmailItemId'
				}]				
			},{
		    	xtype: 'fieldcontainer',
		        width : '100%',
				layout: {
					type : 'hbox'
				},
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
					xtype : 'datefield',
					fieldLabel : getAlumni('DATE_OF_BIRTH'),		
					name : 'requestDOBId',
					itemId : 'requestDOBItemId',
    				listeners: {
						render: function(field) {
                    		return dateFormatRender(field);
                    	},
    				},
				},{
					xtype : 'textfield',
					fieldLabel : getAlumni('GENDER'),		
					name : 'requestGender',
					itemId : 'requestGender'
				},{
					xtype : 'textfield',
					fieldLabel : getAlumni('ACADEMY_LOCATION'),
					store:Ext.create('Academia.store.alumni.alumniList.AlumniALStore'),
					name : 'requestAL',
					itemId : 'requestAL',
					valueField: 'id',
					displayField: 'value',
				}]
			},{
		    	xtype: 'fieldcontainer',
		        width : '100%',
				layout: {
					type : 'hbox'
				},
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
				    xtype : 'customcombobox',
				    fieldLabel : getAlumni('PROGRAM'),		
				    name : 'requestProgram',
				    store: Ext.create('Academia.store.facilitiesresources.resourcemaster.ProgramGridStore'),
				    itemId : 'requestProgramItemId',
			    	valueField: 'id',
					displayField: 'value',
				    },
				    {
				    xtype : 'textfield',
				    fieldLabel : getAlumni('OTHER_PROGRAM'),		
				    name : 'requestOtherProgram',
				    itemId : 'requestOtherProgramItemID',
				    cls:'alumniDetailBg'
				    },{
			        xtype : 'customcombobox',
			        fieldLabel : getAlumni('BATCH'),		
			        name : 'requestBatch',
			        itemId : 'requestBatchItemId',
		        	store: Ext.create('Academia.store.alumni.alumniList.AlumniBatchStore'),
		        	valueField: 'id',
					displayField: 'value',
					disabled:  false
			        }]
			},{
		    	xtype: 'fieldcontainer',
		        width : '100%',
				layout: {
					type : 'hbox'
				},
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
				        xtype : 'textfield',
				    fieldLabel : getAlumni('OTHER_BATCH'),		
				    name : 'requestOtherBatch',
				    itemId : 'requestOtherBatchItemID',
				    cls:'alumniDetailBg'
				    },{
				    xtype : 'textfield',
				    fieldLabel : getAlumni('PASSOUT_YEAR'),		
				    name : 'requestPassoutYear',
				    itemId : 'requestPassoutYearItemId'
				    },{
				        xtype : 'textfield',
				    fieldLabel : getAlumni('STUDENT_ID'),		
				    name : 'requestStudentId',
				    itemId : 'requestStudentItemId'
				    }]
			},{
		    	xtype: 'fieldcontainer',
		        width : '100%',
				layout: {
					type : 'hbox'
				},
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
				        xtype : 'textfield',
				        fieldLabel : getAlumni('ADMISSION_ID'),		
				        name : 'requestAdmisssionId',
				        itemId : 'requestAdmisssionItemId'
				        }]
			},{
		    	xtype: 'fieldcontainer',
		        width : '100%',
				layout: {
					type : 'hbox'
				},
				items:[{
					xtype: 'button',
					itemId: 'btnApprove',
					cls: 'CustomToolbarBtnReject',
					ui : 'CustomBtnSubmit',
					text : getAlumni('APPROVE'),
					tooltip: getAlumni('APPROVE'),	
				},{
					xtype: 'button',
					itemId: 'btnReject',
					cls: 'CustomToolbarBtnReject',
					ui : 'CustomBtnCancel',
					text : getAlumni('REJECT'),
					tooltip: getAlumni('REJECT'),
				}]
			}]
});

