/**
 * @author Amit Gupta
 */
var booleanValue=null;
Ext.define('Academia.view.applicantportalsetup.VWAdmApplciantPortalConfigureScreenGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.vwadmapplciantportalconfigurescreengrid',
	store : 'applicantPortalSetup.StoAdmApplicantPortalConfigureScreenStore',
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selModel: {
		showHeaderCheckbox: true,
		checkOnly : true,
		allowDeselect: false,
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnSave',
		text:'Save',
		handler:function(){
			Academia.app.getController('Academia.controller.admission.applicantPortalSetup.ApplicantPortalSetupController').admSaveApplicantPortalConfigureScreenData();
		}
	}],
	columns : [{
		header : getCommonTranslation('SCREENNAME'),
		dataIndex : 'screenName',
		flex:1
	},{
		header : getCommonTranslation('SCREENMODE'),
		dataIndex : 'screenMode',
		flex:1
	},{
		header : getCommonTranslation('FIELD_DISPLAY_NAME'),
		dataIndex : 'fieldDisplayName',
		flex:1
	},{

		header : getCommonTranslation('FIELD_TYPE'),
		dataIndex : 'fieldType',
		flex:1
	},{
		header : getCommonTranslation('IS_FORM_LOCKED'),
		dataIndex : 'isFieldLocked',
		flex:1,
		renderer: function (value) {
			if(value == true){
				return value = getCommonTranslation('GRID_FIELD_LOCKED');
			}else{
				return value = getCommonTranslation('GRID_FIELD_UNLOCKED');
			}
		}
	},{
		header : getCommonTranslation('FIELD_MAND_OPTIONAL'),
		dataIndex : 'isMandatory',
		flex:1,
		editor : {
			xtype: 'customcombobox',
			name:'fieldMandatoryAP',
			store:Ext.create('Academia.store.dynamicformrendering.configurescreen.OptionalMandatoryStore'),
			valueField : 'id',
			displayField : 'value',
			editable: false,
			listeners: {
				focus: function(combo, eOpt) {
					if(combo.getValue() == true || combo.getValue() == 'true') {
						combo.setRawValue(getCommonTranslation("GRID_FIELD_MANDATORY"));
					}else{
						combo.setRawValue(getCommonTranslation("GRID_FIELD_OPTIONAL"));
					}
				},
				render: function(combo) {
					combo.getStore().load();
				},
				
			}
		},
		renderer: function (value) {
			if(value == true || value == 'true') {
				return getCommonTranslation('GRID_FIELD_MANDATORY');
			}else{
				return getCommonTranslation('GRID_FIELD_OPTIONAL');
			}
		}
	},{
		header:getCommonTranslation('MODULE_SEQUENCE'),
		flex:1,
		sortable:false,
		dataIndex : 'sequenceNo',
		style: {
			'text-align': 'center'
        },
		editor: {
        	xtype: 'numberfield',
        	name: 'sequenceNo',
        	minValue:1,
        	maxLength: 6,
        	width: 12,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowDecimals:false,
        	style: {
                margin: 'auto'
            },
        	itemId: 'sequenceNoItemId',
        	listeners: {
        		blur: function(obj, record){
        			var grid = obj.up('grid')
        			record = obj.getValue();
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var rowIndex = selectedRecord.index;
        			var items = grid.getStore().data.items;
					var isValid = false;
					var isIndexValid = true;
					Ext.each(items, function(item, index, opt) {
						if (rowIndex != index) {
							if (item.data.sequenceNo != record) {
								isValid = true;
							}else{
								isIndexValid = false;
							}
						}else{
							isValid = true;
						}
						
					});
					if (isValid && isIndexValid) {
						//rec.tdCls = 'gridInputCustomStyleForSqeuence';
						//return value;
					}else{
						obj.reset();
					}
        			
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	var data=record.data;
        	var oldValue = record.modified.sequenceNo;
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return value;
					
				}
				catch(e){
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }			
	},{
		header : getCommonTranslation('FIELD_VISIBILITY'),
		dataIndex : 'isVisible',
		flex:1,
		editor : {
			xtype: 'customcombobox',
			name:'fieldVisibilityAP',
			store:Ext.create('Academia.store.common.YesNoDynamicFormCombo'),
			valueField : 'name',
			displayField : 'value',
			editable: false,
			
		},
		
	},{
		header : getCommonTranslation('HELP_TEXT'),
		dataIndex : 'helpText',
		flex:1,
		renderer: function (value,metaData) {
			return '<a href="#">'+getCommonTranslation('HELP_TEXT')+'</a>';				
		}
	},{
		header : getCommonTranslation('DEF_VALUE'),
		dataIndex : 'defaultValue',
		flex:1,
		editor : {
			xtype: 'textfield',
			itemId:'defaultValueId',
			name:'defaultValue'
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners:{
			edit:function(editor, context){
				context.column.field.setValue('true');
			},
			beforeedit: function(editor, context){
				var rowData=context.record.data;
				if(context.field == 'isVisible'){
					if(rowData.isFieldLocked){
						return false;
					}
				}

				if(context.field == 'defaultValue'){
					if(rowData.isFieldLocked){
						return false;
					}
				}

				if(context.field == 'isMandatory'){
					if(rowData.isFieldLocked || (rowData.fieldType == 'checkbox' 
						|| rowData.fieldType == 'checkboxfield' 
							|| rowData.fieldType == 'radiogroup' 
								|| rowData.fieldType == 'radiofield' 
									|| (rowData.fieldType == 'fieldcontainer' && context.store.data.items[0].data.screenName != "Student Enquiry Details" && context.store.data.items[0].data.screenName != "Manage Enquiry") 
									|| rowData.fieldType == 'fieldset' 
										|| ((rowData.fieldType == 'filefield' && context.store.data.items[0].data.screenName != "Applicant Details") && (rowData.fieldType == 'filefield' && context.store.data.items[0].data.screenName != "Competitive Exam") && (rowData.fieldType == 'filefield' && context.store.data.items[0].data.screenName != "Personal Details Info")) 
										|| rowData.fieldType == 'button')
										|| rowData.isDefaultMandatory) {   
						return false;
					}
				}
			}         
		}
	}]
});
