/**
 * Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.view.attendance.FacultySearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.facultysearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype:'form',
		title: getCommonTranslation('FACULTY_SEARCH_TITLE'),
		frame:true,
		width:'100%',
		items: [{
			xtype : 'fieldcontainer',
			width : '100%',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel:getPersonModuleTranslation('STUDENT_ATT_TYPE'),
				name : 'attendanceType',
				itemId : 'studentAtt_studentAttendanceType',
				store : 'attendance.StudentAttendanceType',
				displayField : 'value',
				valueField : 'value'					        	 
			},{	
				xtype : 'numberfield',
				name : 'noOfBackDays',
				itemId : 'studentAtt_noOfBackDays',
				fieldLabel : getCommonTranslation('NUM_OF_DAYS'),
				minLength: 0,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false
			},{  
				xtype: 'radiogroup',
				itemId:'timeTablePlanningId',
				fieldLabel: getCommonTranslation('TIMETABLE_PLANNING'),
				items:[
				       { boxLabel: getCommonTranslation('YES'), name: 'sessionPlanningFlag', inputValue: true,checked : true },
				       { boxLabel: getCommonTranslation('NO'), name: 'sessionPlanningFlag', inputValue: false}
				       ]
			},{
				xtype : 'textfield',
				name : 'academyLocation',
				itemId : 'academyLocationId',
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION')
			}]      	 
		}]        	 
	},{
		xtype:'form',
		frame:true,
		width:'100%',
		items: [{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'hidden',
				name : 'id'
			},
			// for complete day ********************
			{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
				name : 'programId',
				itemId : 'programBatch_programId',
				store:'common.ProgramByAcademyLocationStore',
				displayField:'value',
				valueField:'id',
				width:460,
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},
			{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'programBatch_batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				emptyText: getCommonTranslation('SELECT'),
				allowBlank: false,
				disabled:true,
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodIdItemId',
				fieldLabel: getExaminationTranslation('PERIOD'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				allowBlank: false
			}
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				layout : {
					type : 'hbox'
				},
				items : [
				         //		for course Level Course Drop-Down *************
				         {
				        	 xtype : 'customcombobox',
				        	 width:460,
				        	 fieldLabel : getCourseTxCommonTranslation('COURSE'),
				        	 name : 'courseId',
				        	 itemId : 'courseId',
				        	 store:'attendance.StudentCourses',
				        	 displayField : 'courseCodeName',
				        	 valueField : 'courseId',
				        	 typeAhead : true,
				        	 disable:true,
				        	 forceSelection : true,
				        	 allowBlank:false,
				        	 hidden:true
				         },{
				        	 xtype : 'customcombobox',
				        	 fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
				        	 name : 'componentId',
				        	 itemId : 'componentId',
				        	 store:'course.courseequivalence.CourseComponentEquivalenceStore',
				        	 displayField : 'value',
				        	 valueField : 'id',
				        	 typeAhead : true,
				        	 disable:true,
				        	 forceSelection : true,
				        	 hidden:true
				         },{
				        	 xtype : 'customcombobox',
				        	 fieldLabel : getCourseTxCommonTranslation('SECTION'),
				        	 name : 'courseSectionId',
				        	 itemId : 'CourseSection_ID',
				        	 store:'attendance.SectionByCourseNComponent',
				        	 displayField : 'sectionCode',
				        	 valueField : 'sectionId',
				        	 typeAhead : true,
				        	 forceSelection : true,
				        	 hidden:true
				         }]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				itemId:'programBatchContainer',
				hidden:true,
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items :[
				        //for program base section Program batch Period Drop - Down *****************	        
				        {
				        	xtype: 'customcombobox',
				        	fieldLabel: getCourseTxCommonTranslation('PROGRAM'),
				        	width:460,
				        	name:'courseProgramId',
				        	itemId: 'courseProgramID',
				        	emptyText:getCourseTxCommonTranslation('SELECT'),
				        	store:'attendance.AllProgramMappedByCourse',
				        	displayField:'programName',
				        	valueField: 'programId',
				        	typeAhead:true,
				        	allowBlank:false,
				        	forceSelection:true
				        },
				        {
				        	xtype: 'customcombobox',
				        	fieldLabel: getCourseTxCommonTranslation('BATCH'),
				        	name:'programBatchCourse',
				        	itemId: 'programBatchCourseID',
				        	emptyText:getCourseTxCommonTranslation('SELECT'),
				        	store:'common.BatchesByProgramId',
				        	displayField: 'value',
				        	valueField: 'id',
				        	typeAhead:true,
				        	disabled:true,
				        	allowBlank:false,
				        	forceSelection:true
				        },{
				        	xtype: 'customcombobox',
				        	fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				        	name:'programBatchPeriod',
				        	itemId: 'programBatchPeriodID',
				        	emptyText:getCourseTxCommonTranslation('SELECT'),
				        	store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				        	displayField: 'value',
				        	valueField: 'id',
				        	allowBlank:false,
				        	typeAhead:true,
				        	disabled:true,
				        	forceSelection:true
				        }]
			},
			// This drop down is for both condition complete day and and multiple section and
//			for program base section also  ******************* 
			{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 226,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'programCoursection_ID',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				forceSelection : true,
				allowBlank: false
			},
			// this is for complete day and multiple session condition ******************	
			{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('FACULTY'),
				width: 226,
				labelAlign: 'top',
				itemId:'facutlyId',
				name : 'facutly',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'facultyName',
				valueField : 'facultyId',
				typeAhead : true,
				readOnly :true,
				forceSelection : true
			},{
				xtype : 'fieldcontainer',
				width: 'auto',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('DATE'),
					name : 'dateOfAttendance',
					itemId:'dateOfAttendance_Id',
					maxValue : new Date(),
//					format : CONSTANTS.DATE_FORMAT,
					//--submitFormat : CONSTANTS.DATE_FORMAT,
					vtype : 'daterange',
					allowBlank: false,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				}]
			},
			// this Drop-Down for course level both condition course base section and program base section
			{
				xtype : 'customcombobox',
				width: 226,
				labelAlign: 'top',
				fieldLabel : getCourseTxCommonTranslation('FACULTY'),
				itemId:'facutlyListId',
				name : 'facutlyList',
				store:'attendance.AttendanceFacultyList',
				displayField : 'facultyName',
				valueField : 'facultyId',
				allowBlank:false,
				typeAhead : true,
				forceSelection : true,
				hidden:true
			},{
				xtype : 'fieldcontainer',
				width: 'auto',
				itemId:'timeContainer',
				hidden:true,
				layout : 'hbox',
				defaults : {
//					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'timefield',
					name : 'fromTime',		
					itemId : 'fromTime',			
					fieldLabel:getProgramandcourseTranslation('START_TIME'),
					format:'g:i A',
					vtype: 'timerange',
					endTimeField : 'toTime',
					width:100,
					allowBlank: false
				},{
					xtype : 'timefield',
					name : 'toTime',		
					itemId : 'toTime',			
					fieldLabel:getProgramandcourseTranslation('END_TIME'),
					format:'g:i A',
					vtype: 'timerange',
					startTimeField :'fromTime',
					width:100,
					allowBlank: false
				}]
			},{
				xtype: 'customcombobox',
				name: 'timeSlotList',
				itemId:'timeSlotListId',
				multiSelect:true,
				width: 226,
				labelAlign: 'top',
				fieldLabel: getCourseTxCommonTranslation('TIME_SLOT'),
				store:'attendance.TimeSlotList',
				displayField:'value',
				valueField:'value',
				typeAhead:true,
				forceSelection:true,
				hidden:true
			}

			]}
	]
});