/**
 *  Akshay Sharma
 */
Ext.define('Academia.view.attendance.MyLeaveReportGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.myleavereportgrid',
	store : 'attendance.MyLeaveReportStore',
	title : getProgramandcourseTranslation('LEAVE_REPORT'),
	border: true,
	autoScroll: true,
	refreshStoreData:true,
	id:'myleavereportgridId',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
			store : 'attendance.MyLeaveReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

 },
	columns : [{
		header : getProgramandcourseTranslation('ABSENT_DATE'),
		dataIndex : 'dateOfAbsence',
		sortable : true,
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('APPLIED_DATE'),
		dataIndex : 'appliedDate',
		flex : 1,
		sortable : true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('LEAVE_STATUS'),
		dataIndex : 'leaveStatus',
		flex : 1,
		sortable : true,
	},{
		header : getProgramandcourseTranslation('APPROVED_DATE_AND_TIME'),
		dataIndex : 'actionDate',
		flex : 1,
		sortable : true,
		renderer: function(date) {
            return dateRender(date)+" "+timeRender(date);
        }
	}]
});
