
Ext.app.AttendanceReportGridStore = Ext.create('Academia.store.attendance.attendancereport.AttendanceReportGrid');
Ext.define('Academia.view.attendance.attendancereport.AttendanceReportGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.attendancereportgrid',
	store : Ext.app.AttendanceReportGridStore,
	title: getProgramandcourseTranslation('STUDENT_ATTENDANCE_SUMMARY'),
	border: true,
	refreshStoreData:true,
	selType: 'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'attendancemainstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		itemId:'dockedItemsItemId',
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : Ext.app.AttendanceReportGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);
    },
	tbar: [{
		xtype : 'button',
		itemId:'sendSurveyBtn',
		text : getCommonTranslation('SEND_SURVEY'),
		tooltip :getCommonTranslation('SEND_SURVEY')
	},
	{
		xtype : 'button',
		itemId:'sendMessageBtn',
		text : getCommonTranslation('SEND_MESSAGE'),
		tooltip :getCommonTranslation('SEND_MESSAGE')
	},{
		xtype : 'button',
		itemId : 'attendanceSummaryReportPrintCertificate',
		tooltip : getCommonTranslation('PRINT_CERTIFICATE'),
		text : getCommonTranslation('PRINT_CERTIFICATE'),
	},'->',{
		xtype: 'button',
		text:getCommonTranslation('EXPORT_REPORT'),
		itemId:'exportReport',
		tooltip :getCommonTranslation('EXPORT_REPORT'),
		disabled:true
	}],
	columns : [{
		header :getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('GENDER'),
		dataIndex : 'gender',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},{
		header :getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'groupName',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex:1
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantCode',
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_SESSIONS'),
		dataIndex : 'totalRecords',
		flex:1,
		renderer : function(value,records) {
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getCommonTranslation('TOTAL_PRESENT'),
		dataIndex : 'presentRecords',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	}, {
		header : getCommonTranslation('TOTAL_ABSENT'),
		dataIndex : 'absentRecords',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	}, {
		header : getCommonTranslation('TOTAL_PRESENT_PERCENT'),
		dataIndex : 'presentPercentage',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return value+"%";
			}else{
				return "0%";
			}
		}
	}, {
		header : getCommonTranslation('TOTAL_ABSENT_PERCENT'),
		dataIndex : 'absentPercentage',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return value+"%";
			}else{
				return "0%";
			}
		}
	}]
});
