var PendingAttendanceCourseWiseStore = Ext.create('Academia.store.attendance.PendingAttendanceCourseWiseStore');


Ext.define('Academia.view.attendance.pendingattendance.PendingAttendanceCourseWiseGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.pendingattendancecoursewisegrid',
	store: PendingAttendanceCourseWiseStore,
	title : getProgramandcourseTranslation('ATTENDANCE_PENDING_REPORT'),
	border: true,
	deferEmptyText: false,
	//emptyText: getCommonTranslation('EMPTY_MESSAGE'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'pendingattendancestructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		itemId:'dockedItemsItemId',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
	          store: PendingAttendanceCourseWiseStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

 },
	columns : [{
		header : getCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVaraintName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('DATE'),
		dataIndex : 'sessionDate',
		flex : 1,
		sortable : true,
		renderer:function(value,records) {
			if(value.length>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('FROM_TIME'),
		dataIndex : 'fromDateTime',
		sortable : true,
		flex : 1,
		renderer: function(date) {
            return timeFormatRender(date);
        }
	},{
		header : getCommonTranslation('TO_TIME'),
		dataIndex : 'toDateTime',
		sortable : true,
		flex : 1,
		renderer: function(date) {
            return timeFormatRender(date);
        }
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true
	}]

});
