/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.bulkdocumentupload.BDUDownloadForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.bdudownloadform',
    frame: false,
    method: 'POST',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'academyLocationId',
            itemId: 'academyLocationItemId',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            queryParam: 'qry',
            typeAhead: true,
            forceSelection: true,
            hideTrigger: false,
            allowBlank: false,
            triggerAction: 'all',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'nestedJsonCombo',
            name: 'userGroupId',
            itemId: 'userGroupItemId',
            fieldLabel: getCommonTranslation('USER_TYPE'),
            store: 'bulkdocumentupload.BDUUserTypeStore',
            valueField: 'id',
            displayField: 'userGroupName',
            editable: false,
            allowBlank: false,
            queryMode: 'local'
        }, {
            xtype: 'nestedJsonCombo',
            name: 'documentTypeId',
            itemId: 'documentTypeItemId',
            fieldLabel: getCommonTranslation('BDU_BULK_DOCUMENT_TYPE'),
            store: 'common.DocumentTypeStore',
            displayField: 'value',
            editable: false,
            valueField: 'id',
            allowBlank: false,
            disabled: true
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            items: [{
                xtype: 'button',
                text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
                itemId: 'downoladBDUDownloadFormBtnItemId',
                style: {
                    marginTop: '20px'
                },
                formBind: true,
                ui: 'CustomBtnSubmit'
            }]
        }]
    }]
});