/**
 * @author Saket.Puranik
 
 * This component is used for to show Calendar academyLocation details.
 */
Ext.define('Academia.view.calendar.entitylist.CalendarAcademyLocationGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.calendaracademylocationgrid',
			/* requires : [ ], */
			store : 'calendar.entitylist.CalendarAcademyLocationStore',
			title : getCommonTranslation('CALENDAR_ACADEMY_LOCATION_TITLE'),
			collapsible:false,
			border: true,
			//autoScroll: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
			columns : [ {
				dataIndex: 'isAssociatedCalendar',
				align: 'center',
				xtype:'checkcolumn',
				editable:false,
			 processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
				 
			 }	
			},{
				header : getCommonTranslation('CALENDAR_ACADEMY_LOCATION'),//Course Name	
				dataIndex : 'academyLocationName',
				sortable : false,	
			    flex : .1
			}],
						
			tbar : [ {
		        xtype: 'label',
		        text: getCommonTranslation('CALENDAR_ACAD_LOC_TITLE'),
		        style: 'font-weight:bold;'
		        }],
			dockedItems : [  {
				xtype : 'toolbar',
				dock : 'top',
				items : [ {
					   xtype: 'checkboxfield',
			    	   boxLabel:getCommonTranslation('CALENDAR_ACADEMY_LOCATION_GRID_TITLE'),
			    	   name:'chkOrg',
			    	   disabled:true,
			    	   itemId:'chkOrg'
				} ]
			} ,{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'calendar.entitylist.CalendarAcademyLocationStore',
					emptyMsg :'<span id="ALGridId" style="margin-top: 60px !important">'+ getCommonTranslation('EMPTY_CALENDAR_ACADEMY_LOCATION_MESSAGE')+'</span>',//No Courses to display
					displayInfo : true
				} ]
			} ]
		});
