/**
 * @author Samarth.Ashturkar
 * This component is used for to Work Timing configuration Grid Details Window 
 */
Ext.define('Academia.view.calendar.holidaysandspecialdaystabs.HolidayListFormWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.holidayListFormWindow',			
			modal : true,
			resizable:false,
			title : getCommonTranslation('CALENDAR_HOLIDAY_DETAILS'),//'Holiday list details'						
			items : [{
				xtype: 'form',
				itemId:'holidayListForm',
			    method : 'POST',
			    margin:0,
			    bodyPadding:'10 10 10 10',
			    plugins : "formlabelrequired",
				defaults:{
					labelAlign:'top'
				},
//			    /standardSubmit : true,
			    items :[{
						xtype : 'hidden',
						itemId:'hidden_id_field',
						name : 'id'
					},{
						xtype : 'hidden',
						itemId:'hidden_calendarId_field',
						name : 'calendarId'
					},{
						xtype : 'hidden',
						itemId:'version',
						name : 'version'
					},{
						xtype : 'datefield',
						name : 'fromDate',			
						itemId : 'fromDate',			
						fieldLabel : getCommonTranslation('CALENDAR_FROM_DATE'),//From date
						editable: false,
						vtype: 'daterange',
						endDateField:'toDate',
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						allowBlank:false,
	    				listeners: {
	    					render: function(field) {
	    						return dateFormatRender(field);
	    					}
	    				}
					},{
						xtype : 'datefield',
						name : 'toDate',			
						itemId : 'toDate',
						fieldLabel : getCommonTranslation('CALENDAR_TO_DATE'),//'To Date',
						editable: false,
						vtype: 'daterange',
						startDateField: 'fromDate',
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						allowBlank:false,
	    				listeners: {
	    					render: function(field) {
	    						return dateFormatRender(field);
	    					}
	    				}
					},{
						xtype : 'textfield',
						name : 'holidayReason',						
						fieldLabel : getCommonTranslation('CALENDAR_OCCASION'),//Occasion
						itemId:'holidayReason',
						allowBlank:false
					},
					{
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos',
		            items: [{
						xtype : 'button',				
						itemId:'btnSaveHolidayListForm',
						text : getCommonTranslation('SAVE'), //Submit
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind : true
					},{
						xtype : 'button',
						itemId:'btnCancelHolidayListForm',
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
					}]
			    }]
			}]			
		});
