/**
 * @author Samarth.ashturkar
 * 
 * This component is used for to show Work Timing Configuration Details Grid
 */
Ext.define('Academia.view.calendar.holidaysandspecialdaystabs.HolidayListGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.holidaylistgrid',
			title : getCommonTranslation('CALENDAR_HOLIDAY_DETAILS'),//'Holiday list details'		
			collapsible:false,
			border: true,
			initComponent: function() {
			        var me = this;
			        me.holidayListGridStore = Ext.create('Academia.store.calendar.HolidayListGridStore', {});
			        Ext.apply(me, {
			        	store : me.holidayListGridStore,
			        	viewConfig : {
							stripeRows : CONSTANTS.STRIPEROWS
						},
						columns : [{
							header : getCommonTranslation('CALENDAR_FROM_DATE'),//From date
							dataIndex : 'fromDate',
							align: 'center',
							sortable : true,	
						    flex : .2,
						    renderer: function(date) {
					            return dateRender(date);
					        }
						}, {
							header : getCommonTranslation('CALENDAR_TO_DATE'),//'To Date',
							dataIndex : 'toDate',
							align: 'center',
							sortable : true,	
							flex : .2,
							renderer: function(date) {
					            return dateRender(date);
					        }
						}, {
							header : getCommonTranslation('CALENDAR_OCCASION'),//Occasion
							dataIndex : 'holidayReason',
							align: 'center',
							sortable : true,	
							flex : .3
						}],
						tbar : [{
							xtype : 'button',				
							itemId : 'btnAddHolidayList',
							tooltip : getCommonTranslation('ADD'),//Add
							glyph: ICONGLYPH.ADDGLYPH
							//text : getCommonTranslation('ADD')
						},{
							xtype : 'button',				
							itemId : 'btnEditHolidayList',
							tooltip : getCommonTranslation('EDIT'),//Edit
							glyph: ICONGLYPH.EDITGLYPH
							//text : getCommonTranslation('EDIT')
						},{
							xtype : 'button',				
							itemId : 'btnViewHolidayList',
							tooltip : getCommonTranslation('VIEW'),//View
							iconCls: 'view-icon'
							//text : getCommonTranslation('VIEW
						},{
							xtype : 'button',				
							itemId : 'btnDeleteHolidayList',
							cls: 'CustomToolbarBtnReject',
							tooltip :getCommonTranslation('DELETE'),//Delete
							glyph: ICONGLYPH.DELETEGLYPH
							//text : getCommonTranslation('DELETE')
						}],
						dockedItems : [ {
							xtype : 'toolbar',
							dock : 'bottom',
							items : [ {
								xtype: 'custompagingtoolbar',
					            plugins:['pagesize'],
								store : me.holidayListGridStore,
					            emptyMsg: getCommonTranslation('CALENDAR_EMPTY_HOLIDAY_DETAILS_MESSAGE'),//No holiday list to display
								displayInfo : true
							}]
						}]
			        });
			        me.callParent(arguments);
			    },
				showHolidayListForm: function() {				
					var winHolidayListForm=Ext.widget('holidayListFormWindow');
					winHolidayListForm.show();					
				}
		});