/**
 * @author Deepak S
 */
Ext.define('Academia.view.campaignnew.CampaignNewFilter',{
	extend: 'Ext.form.Panel',
	alias: 'widget.campaignnewfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'multiselectcombofield',
            name: 'multiBrandCampus',
            itemId: 'multiBrandCampusId',
            fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
            valueField: 'id',
			displayField: 'value',
			store: 'user.UserAcademyLocationStore',
  			//minChars:3,
  			//queryParam:'qry',
  			width: 698,
  			height:58,
  			cls:'multiBrandCampusCls',
  			maxHeight:125,
  			typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'intakeYear',
			itemId: 'intakeYearId',
			fieldLabel: getCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true
		}, {
			xtype: 'customcombobox',
			name: 'campaignType',
			itemId: 'campaignTypeId',
			fieldLabel: getCommonTranslation('CAMPAIGN_TYPE'),
			store: 'campaignnew.CampaignTypeStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection: true
		},{
			xtype: 'customcombobox',
			name: 'presentationType',
			itemId: 'presentationTypeId',
			fieldLabel: getCommonTranslation('PRESENTATION_TYPE'),
			store: 'campaignnew.PresentationTypeStore',
			valueField: 'id',
			disabled:true,
			displayField: 'value',
			editable: false,
			forceSelection: true
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'campaignName',
			itemId: 'campaignNameId',
			fieldLabel : getCommonTranslation("CAMPAIGN_NAME"),
			valueField: 'id',
			displayField: 'value',
			store: 'campaignnew.CampaignNameFilterStore',
			queryParam:'campaignName',
			minChars:3,
			width : 462,
			maxLength:500,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'status',
			itemId: 'statusId',
			fieldLabel: getCommonTranslation('STATUS'),
			store: 'campaignnew.CampaignStatusStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			triggerAction: 'all',
			forceSelection: true
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'datefield',
			name: 'startDate',
			itemId:'startDateId',
			endDateField:'endDateId',
			vtype: 'daterange',
			fieldLabel:getExaminationTranslation('START_DATE'),
			listeners: {
				render: function(obj) {
					return dateFormatRender(obj);					
				}
			}
		},{
			xtype: 'datefield',
			name: 'endDate',
			itemId:'endDateId',
			startDateField:'startDateId',
			vtype: 'daterange',
			fieldLabel:getProgramandcourseTranslation('END_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{ 
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		style: {
			marginTop: '40px!important'
		},
		items: [{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			style: {
				marginTop: '10px!important'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'school',
				itemId: 'schoolId',
				fieldLabel: getCommonTranslation("SCHOOL"),
				valueField: 'id',
				displayField: 'value',
				store: Ext.create('Academia.store.campaignnew.CampaignSchoolStore'),
				queryParam:'schoolName',
				minChars:3,
				typeAhead:false,
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				//editable: false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				//triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'schoolPriority',
				itemId: 'schoolPriorityId',
				fieldLabel: getCommonTranslation('SCHOOL_PRIORITY'),
				store: Ext.create('Academia.store.campaignnew.SchoolPriorityStore'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				forceSelection: true
			},{
				xtype: 'customcombobox',
				name: 'owner',
				itemId: 'ownerId',
				fieldLabel: getCommonTranslation("OWNER"),
				store : 'resourceutilization.ActiveUserStore',
				displayField : 'valueCode',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				//triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'modeDelivery',
				itemId: 'modeDeliveryId',
				fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
				store: 'common.ModeOfDeliveryStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				forceSelection: true
			},{
				xtype: 'customcombobox',
				name: 'registrationType',
				itemId: 'registrationTypeId',
				fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
				store: 'campaignnew.RegistrationTypeStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				forceSelection: true
			}]
		}],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
