/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.committee.committee.CommitteeForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.committeeform',
	autoScroll: true,
	bodyPadding:'10 10 10 10',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'committeeCode',
			itemId:'committeeCodeItemId',
			fieldLabel : getCommonTranslation("COMMITTEE_CODE"),
			allowBlank:false,
			maxLength: 10
		},{
			xtype : 'textfield',
			name : 'committeeName',
			itemId:'committeeNameItemId',
			fieldLabel : getCommonTranslation("COMMITTEE_NAME"),
			allowBlank:false,
			maxLength: 45
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [/*{
			xtype: 'multiselectcombofield',
			width: 460,
			name: 'multiselectAcademyLocation',
			itemId: 'multiselectAcademyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'user.UserAcademyLocationStore',
			displayField:'value',
			valueField:'id',
			maxLength:15000,
			autoloadStore: false,
			allowBlank:false,
			height:'10px'
		},*/{
			xtype: 'customcombobox',
			name: 'user',
			itemId: 'userItemId',
			fieldLabel: getCommonTranslation("COMMITTEE_CO_ORDINATOR"),
			valueField: 'committeeCoordinatorId',
			displayField: 'displayValue',
			store: 'committee.committee.CommitteeCoordinator',
  			queryParam:'codeOrName',
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			allowBlank:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			maxLength:100,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{committeeCoordinatorCode}'+ ' / ' + '{committeeCoordinatorName}'+
  					'</div>';
  				}
  			}
		}, {
			xtype: 'customcombobox',
			name: 'committeeType',
			itemId: 'committeeTypeItemId',
			fieldLabel: getCommonTranslation("COMMITTEE_TYPE"),
			valueField: 'id',
			displayField: 'value',
			store: 'committee.committee.CommitteeType',
  			allowBlank:false,
  			editable: false,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
  			}
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		style:{
			marginTop:'22px',
			marginBottom:'15px'
		},
		defaults : {
			labelAlign : 'top'
		},
		items : [ {
			html: '<b><u>Validity</u></b>',
			margin: 0,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'datefield',
			name: 'fromDate',
			itemId:'fromDateItemId',
			endDateField:'toDateItemId',
			vtype: 'daterange',
//			value:new Date(),
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			fieldLabel:getExaminationTranslation('FROM_DATE'),
			allowBlank:false,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		},{
			xtype: 'datefield',
			name: 'toDate',
			itemId:'toDateItemId',
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			fieldLabel:getCommonTranslation('TO_DATE'),
			allowBlank:false,
			vtype: 'daterange',
			startDateField: 'fromDateItemId',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
			},{
		    xtype: 'datefield',
		    name: 'panelStartDate',
		    itemId: 'panelStartDateItemId',
		    fieldLabel: getCommonTranslation('PROGRESSION_PANEL_DATE'),
		    vtype: 'daterange',
			hidden: true,
		    startDateField: 'fromDateItemId',
		    listeners: {
		        render: function (field) {
		            field = dateFormatRender(field);
		            var fromDateField = field.up('form').down('#fromDateItemId');
		            if (fromDateField) {
		                field.setMinValue(fromDateField.getValue());
		            }

		            fromDateField.on('change', function (fld, newValue) {
		                field.setMinValue(newValue);
		                if (field.getValue() < newValue) {
		                    field.setValue(null);
		                }
		            });

		            return field;
		        }
		    }
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusItemId',
			store:'common.StatusComboStore',
			displayField:'name',
			valueField:'id',
			value:'ACTIVE',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('STATUS'),
			/*listeners: {
				render: function(object) {
					object.getStore().load({
						callback:function(record) {
							object.setValue(record[0].data.id);
						}
					});
				}
			}*/
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 460,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'textarea',
			name:'description',
			itemId:'descriptionId',
			width: 460,
			maxLength : 255,
			fieldLabel: getExaminationTranslation('Description')
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [{
			xtype : 'button',
			text : getCommonTranslation("SAVE") ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			itemId: 'resetBtnCommittee',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			/*listeners: {
				click: function(object) {
					var form = object.up('form').getForm();
					form.findField('user').reset();
					form.reset();
				}
			}*/
		}]
	}]
});
