Ext.define('Academia.view.common.AddressFieldsForm', {
	//extend : 'Ext.form.Panel',
    extend:'Academia.view.common.IdGeneratorCustomForm',
    customFieldEntity:CONSTANTS.ADDRESS_CF_DATA,
    customFieldEntityType:CONSTANTS.ADDRESS_CF_DISPLAY_NAME,
	alias : 'widget.addressfieldsform',
	autoScroll: false,
	defaults : {
		labelAlign:'top',
		enforceMaxLength : true,
		width: 226
	},
	items : [{
		xtype: 'fieldcontainer',
		itemId: 'topFieldContainer',
		layout: {
			type: 'hbox'
	    },
	    width:450
	},{
    		xtype : 'hidden',
    		name : 'id'
        },{
        	xtype : 'hidden',
    		name : 'version'
        },{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('ADDRESS_TYPE'),
		name : 'addressType',
		itemId : 'addressTypeId',
		store:'organization.AddressTypeStore', 
		valueField : 'id',
		displayField : 'addressTypeName',
		editable : false,
		hidden:true
	}, {
		xtype : 'textareafield',
		fieldLabel : getCommonTranslation('ADDRESS'),
		name : 'addressText',
		itemId : 'addressText',
		maxLength: 1000,
		//vtype: 'NospaceAsInput',
		allowBlank:false,
		width: 460,
		listener:{
			blur:function(){}
		}
	}, {
		xtype : 'textareafield',
		fieldLabel : getCommonTranslation('ADDRESS_OTHER_LANGUAGE'),
		name : 'addressTextOtherLanguage',
		itemId : 'addressOtherLanguageId',
		width: 460,
		hidden:true,
		listener:{
			blur:function(){}
		}
	},{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
	    	xtype: 'textfield',
	    	fieldLabel : getPersonModuleTranslation('GOOGLE_ADDRESS_COUNTRY'),
	    	hidden: true,
	    	name: 'countryIdText',
	    	itemId: 'countryIdText'
	    },{
	    	xtype: 'textfield',
	    	fieldLabel : getPersonModuleTranslation('GOOGLE_ADDRESS_COUNTRY_REGION'),
	    	hidden: true,
	    	name: 'parentCountryRegionIdText',
	    	itemId: 'parentCountryRegionIdText',
	    	allowBlank:true
	    },{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
        		hiddenName : 'country',
        		itemId : 'countryId',
        		store:Ext.create('Academia.store.common.CountryStore'),
        		valueField : 'id',
        		displayField : 'countryName',
        		name : 'country',
        		//editable : false,
        		//valueNotFoundText:"",     
    			queryParam:'countryName',   		        						
				forceSelection :true,
				allowBlank:false,
				typeAhead : false,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				hideTrigger:false,
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryName}'  +
		                    '</div>';
		                }
		            }
        	},{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//        		name : 'genericField1',
        		itemId : 'parentCountryRegionId',
        		store:Ext.create('Academia.store.organization.CountryRegionStore'),
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'parentCountryRegion',
    			queryParam:'regionName',   		 
        		//editable : false,
        		//valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false,
				typeAhead : false,
				hideTrigger:false,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryRegionName}'  +
		                    '</div>';
		                }
		            }
        	}]
	}, {
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
	    	xtype: 'textfield',
	    	fieldLabel : getPersonModuleTranslation('GOOGLE_ADDRESS_CITY'),
	    	hidden: true,
	    	name:'cityIdText',
	    	itemId: 'cityIdText',
	    	allowBlank:true
	    },{
    		xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
    		hiddenName : 'city',
    		itemId : 'cityId',
//    		store:'organization.CityStore',
    		store:Ext.create('Academia.store.organization.CityByCountryRegion'),
    		valueField : 'id',
//    		displayField : 'cityName',
    		displayField : 'value',
    		name : 'city',
			queryParam: 'searchText',   		 
    		//editable : false,    
    		//valueNotFoundText:"",        		
			forceSelection :true,
			allowBlank:false,
			typeAhead : false,
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            },
                listeners: {
                    afterrender: function(cmp) {
                        cmp.bindStore(Ext.create('Academia.store.organization.CityByCountryRegion', {
                            storeId: cmp.id
                        }));
                    }
                }
    	},{
    		xtype : 'textfield',
    		fieldLabel : getCommonTranslation('PINCODE'),
//    		hiddenName : 'pincode',
    		itemId : 'pincodeId',
    		name : 'pincode',
    		minValue : 0,
    		maxLength: 10,
    		maskRe:/^[a-zA-Z0-9\s]+$/,
    		disabled:true,
      	    /*mouseWheelEnabled :false,
      	    hideTrigger :true,
      	    allowExponential:false,
      	    allowDecimals:false,*/
//			allowBlank:false
    	},{
    		xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('PINCODE_NEW'),
    		itemId : 'pincodeNewId',
    		store : 'common.CityPinCodeStoreSmartSearch',
    		valueField : 'id',
    		displayField : 'value',
    		name : 'pincodeNew',
			queryParam: 'searchText',   		        		
			forceSelection :true,
			typeAhead : false,
			hidden : true,
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
    	}]
	    },{
		    xtype: 'fieldcontainer',
		    width: 'auto',
		    fieldLabel : getCommonTranslation('GEOGRAPHICAL_AREA'),
		    itemId : 'geographicalAreaContainer',
			name : 'geographicalAreaContainer',  	
		    defaults: {
		    	labelAlign: 'top',
		    	width: 226
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
	    		xtype : 'textfield',
	    		hiddenName : 'Latitude',
	    		itemId : 'latitudeItemId',
	    		name : 'latitude',  		        		
				emptyText: getCommonTranslation('LATITUDE')
	    	},{
	    		xtype : 'textfield',
	    		hiddenName : 'Longitude',
	     		itemId : 'longitude',
	    		name : 'longitude',
	    		emptyText: getCommonTranslation('LONGITUDE')
	    	}]
		    },/*{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_Generic_Field_1'),
        		hiddenName : 'genericField1',
        		itemId : 'genericFieldId1',
        		store:'organization.CountryRegionStore',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		triggerAction : 'all',
        		name : 'parentCountryRegion',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false
        	}, {
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_Generic_Field_2'),
        		hiddenName : 'genericField2',
        		itemId : 'genericFieldId2',
        		store:'organization.CountryRegionStore1',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'countryRegion',
        		triggerAction : 'all',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true        
        	}]
	}, */{
		/*xtype: 'fieldset',
		title : getAdmissionTranslation('CONTACT_INFORMATION'),
		itemId : 'contactFieldSet',*/
		/*style : {
			marginLeft : '10px'
		},*/
	    	// V2D-98400
	/*	xtype: 'fieldset',
		 width: '100%',
		itemId : 'contactFieldSet',
		defaults: {
			labelAlign: 'top'
		},
		style: {
			marginTop: '30px !important',
			marginLeft: '-5px !important'
		},
		title: getAdmissionTranslation('CONTACT_INFORMATION'), // Contact Information
		items: [{
			html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>',
			margin: -1
		},{
		defaults: {
			labelAlign: 'top'
		},*/
		xtype: 'fieldcontainer',
	    width: '100%',
		fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
		//allowBlank:false,
		itemId:'addressPhoneFieldContainerId',
		layout : {
			type : 'hbox'
		},
		defaults: {
			enforceMaxLength : true,
			labelAlign: 'top',
			width: 226
			//cls:'inputInRow'
		},
		items : [ {
			xtype : 'customcombobox',
			hiddenName : 'phoneNumber1',
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			name : 'phoneCountryCode',
			itemId : 'phoneCountryCode',
			editable : false,			
			width: 108
		}, {
			xtype : 'textfield',
			name : 'AreaCode',
			name : 'phoneAreaCode',
			width: 108,
			maxLength: 5,
			maskRe:/\d/,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        /*hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        allowExponential:false,*/
	        itemId : 'phoneAreaCode',
		}, {
			xtype : 'numberfield',
			itemId : 'phoneNoField',
			name : 'phoneNo',
			//maxLength: 10,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        allowExponential:false,
	        //maxLength: 10
		} ]
	}, {
	    	xtype: 'fieldcontainer',
		    width: '100%',
	    	itemId:'addressCellFieldContainerId',
		    fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
	    	defaults: {
			enforceMaxLength : true,
			labelAlign: 'top',
			width: 226
		},
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'customcombobox',
			name : 'cellCountryCode',
			itemId : 'cellCountryCode',
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			editable : false,
			width: 108
		}, {
			xtype : 'numberfield',
			name : 'cellNo',
			itemId : 'cellNo',
			minLength: 0,
			maxLength: 15,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        allowExponential:false
		} ]
		// V2D-98400
//	}] 
	}, {
		xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 226
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [ {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
            		name : 'primaryeEmailId',
            		vtype: 'email',
            		itemId : 'primaryeEmailId',
            		maxLength: 100
//            		allowBlank: false
            	}, {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
            		name : 'alternateEmailId',
            		vtype: 'email',
            		allowBlank: true,
            		itemId : 'alternateEmailId',
            		maxLength: 100
            	}]
	}, {
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	        labelAlign: 'top',
	        width: 226
	    },
	    layout: {
	        type: 'hbox'
	    },
	    items: [{
	        xtype: 'textfield',
	        fieldLabel: getCommonTranslation('ALA_WEBSITE_URL'),
	        name: 'websiteURL',
	        itemId: 'websiteURLItemId',
	        regex:/^(https?:\/\/)?(www\.)?([-a-z0-9]{1,63}\.)*?[a-z0-9][-a-z0-9]{0,61}[a-z0-9]\.[a-z]{2,6}(\/[-\w@\+\.~#\?&\/=%]*)?$/i,
	        regexText :'Website URL format should be http://www.eg.com or www.eg.com or eg.com',
	        hidden: true
	    },{
    		xtype : 'textfield',
    		fieldLabel : getCommonTranslation('FAX_NUMBER'),
            itemId : 'faxNumberId',
    		name : 'faxNumber',
    		minValue : 0,
    		maxLength: 25,
    		
    	}]
	},
	{
        xtype: 'multiselectcombofield',
        name: 'otherAddressTypeId',
        itemId: 'otherAddressTypeItemId',
        autoloadStore: false,
        width: 460,
        fieldLabel: getCommonTranslation('COPY_THIS_ADDRESS_TO'),
        //store:'common.OtherAddressCopyStore',
        valueField: 'id',
        displayField: 'addressTypeName',
        //queryParam: 'qry',
        typeAhead: true,
        triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
        enableKeyEvents: 'true',
        hideTrigger: false,
        forceSelection: true,
        hidden: true,
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.common.OtherAddressCopyStore');
				combo.bindStore(store);
			}
		},
        listConfig: {
            listeners: {
                beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                }
            },
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            getInnerTpl: function() {
                return '<div class="search-item">' +
                    '{code}' +
                    '</div>';
            }
        }
    }
	
//	, {
//		border : false,
//
//		layout : {
//			type : 'hbox',
//			//buttonAlign : 'center'
//			width : '100%'
//		},
//		items : [ {
//			xtype : 'button',
//			text : 'Save',
//			itemId : 'saveButtonId',
//			buttonAlign : 'right',
//			ui:'CustomBtnSubmit',
//			scale:CONSTANTS.BUTTONSIZE
//			
//		}, {
//			xtype : 'button',
//			text : 'Cancel',
//			//buttonAlign : 'center',
//			ui: 'CustomBtnCancel',  // edited by Guruling
//			itemId : 'cancelButtonId',
//			scale : CONSTANTS.BUTTONSIZE
//
//		}]
//	} 
	]

});
