/**
 * @Author sachin.bangar
 * 
 * This is extended form component to show custom fields of entities. 
 */
Ext.define('Academia.view.common.CustomFieldForm', {
	extend : 'Ext.form.Panel',

    alias: 'widget.customfieldform',

    constructor: function(cnfg) {
    	this.customFieldNameData = new Array();
    	this.callParent(arguments); //Calling the parent class constructor
        this.initConfig(cnfg); //Initializing the component
        this.getForm().getValues = Ext.bind(this.getFormValues, this); //Binding external function to basic form component
        this.getForm().setValues = Ext.bind(this.setFormValues, this);
        this.on('beforerender', this.onBeforeRender);
        
    },
    
    /**
     * This function is used for to add custom field link if entity having custom fields.
     * 
     * @param cmp
     *          It is form component on listening render event
     */
    onBeforeRender: function(cmp, eOpts) {
        var me = this;
        var customFieldDataModel = Academia.model.customfields.CustomFieldDataModel;
        var isExist = false;
        if(customFieldDataModel.hasOwnProperty("customFieldData")){
        	Ext.Array.each(customFieldDataModel.customFieldData, function(entityObject) {
                if (!isNullOrEmpty(me.customFieldEntity) && entityObject.tableName === me.customFieldEntity 
                		&& entityObject.wsCustomFieldConfigModels.length > 0) {
                	
                	if( entityObject.tableName === 'incidents' ){
                		if( me.customFieldEntityType === entityObject.displayName ){
                			entityObject.wsCustomFieldConfigModels.sort(function(a, b) {
                                return a.displayOrder - b.displayOrder;
                            });
                            isExist = true;
                		}
                	} else if( entityObject.tableName === 'persons' || entityObject.tableName === 'work_experience' ){
                		if( me.customFieldEntityType === entityObject.displayName ){
                			entityObject.wsCustomFieldConfigModels.sort(function(a, b) {
                                return a.displayOrder - b.displayOrder;
                            });
                            isExist = true;
                		}
                	} else {
                		entityObject.wsCustomFieldConfigModels.sort(function(a, b) {
                            return a.displayOrder - b.displayOrder;
                        });
                        isExist = true;
                	}
                }
            });
        }
        
        if (isExist == true) {
        	me.addCustomFieldComponent();
            me.doLayout();
        }
        
    },
    /**
     * get position to add custom field 
     * @param me form
     */
    getPositionToAddCustomField: function(me){
    	var addPosition, itemLength = 0;
    	if(me.hasOwnProperty("addPosition")){
    		addPosition = me.addPosition;
    	}else{
    		if(me.xtype == 'parentguardianform' || me.xtype == 'campaignnewformlayout') {
    			itemLength = me.items.items.length;
        		if(itemLength > 2){
        			addPosition = itemLength-1;
        		}else{
        			addPosition = 0;
        		}
    		} else if(me.xtype == 'addressfieldsform') {
    			itemLength = me.items.items.length;
        		if(itemLength > 2){
        			addPosition = itemLength;
        		}else{
        			addPosition = 0;
        		}
    		}  else if(me.xtype == 'socioeconomicinformationform') {
    			itemLength = me.items.items.length;
        		if(itemLength > 2){
        			addPosition = itemLength-1;
        		}else{
        			addPosition = 0;
        		}
    		}else {
    			itemLength = me.items.items.length;
        		if(itemLength > 2){
        			addPosition = itemLength - 2;
        		}else{
        			addPosition = 0;
        		}
        		if( me.customFieldEntity == 'applicant_hostel_requirement' || me.customFieldEntity == 'student_hostel_requirement' || me.customFieldEntity == 'work_experience' || me.customFieldEntity === 'user_references' || me.customFieldEntity === 'faculty_non_academic_achievements'){
        			addPosition = itemLength - 1;
            	}
    		}
    	}
    	
    	return addPosition;
    },
    /**
     * get position to add custom field 
     * @param me form
     */
    getColumnCountToAddCustomField: function(me){
    	var columns;
    	if(me.hasOwnProperty("columns")){
    		columns = me.columns;
    	}else{
    		columns = 2;
    	}
    	
    	return columns;
    },
    /**
     * This function is used for to get custom field link and also catch click event of that link in that
     * we show custom field form and add fields dynamically on that form component. 
     * 
     * @param me
     *          passing form reference to this function
     */
    addCustomFieldComponent: function(me) {
    	var me = this;
    	var columns, addPosition, isCustomFieldExist = false, fieldColumnCount = 0;
    	var itemArray = new Array();
    	var customFieldDataModel = Academia.model.customfields.CustomFieldDataModel;
    	columns = me.getColumnCountToAddCustomField(me);
    	addPosition = me.getPositionToAddCustomField(me);
        Ext.Array.each(customFieldDataModel.customFieldData, function(object) {
            if (!isNullOrEmpty(me.customFieldEntity) && object.tableName === me.customFieldEntity && object.wsCustomFieldConfigModels.length > 0) {
            	marginCustomField = "0 0 0 0";
            	if(object.tableName == 'applicant_person' || object.tableName == 'prog_batch_period_config'){
            		marginCustomField = "0 0 0 10";
            	}
            	if(object.tableName == 'scholarship'){
            		marginCustomField = "0 0 0 10";
            		columns = 3;
            	}
            	
            	if( object.tableName === 'incidents' || object.tableName === 'persons' || object.tableName === 'work_experience'){
            		if( me.customFieldEntityType === object.displayName ){
            			
            			Ext.Array.each(object.wsCustomFieldConfigModels, function(fieldObject) {
                    		var field = me.getComponent(fieldObject, me);
                    		itemArray.push(field);
                    		fieldColumnCount++;
                            if(fieldColumnCount == columns){
                            	var fieldContainer = Ext.create('Ext.form.FieldContainer', {
                                    width: 'auto',
                                    margin: marginCustomField,
                                    plugins : "formlabelrequired",
                                    defaults: {
                                        labelAlign: 'top',
                                        width: 226
                                    },
                                    layout: {
                                        type: 'hbox'
                                    },
                                    items: itemArray
                                });
                            	me.insert(addPosition, fieldContainer);
                            	//me.insert(7, fieldContainer);
                            	itemArray = new Array();
                                addPosition++;
                            	fieldColumnCount = 0;
                            }
                            
                            isCustomFieldExist = true;
                        });
                        if(!isEmpty(itemArray)){
                    		var fieldContainer = Ext.create('Ext.form.FieldContainer', {
                                width: 'auto',
                                plugins : "formlabelrequired",
                                defaults: {
                                    labelAlign: 'top',
                                    width: 226
                                },
                                layout: {
                                    type: 'hbox'
                                },
                                items: itemArray
                            });
                    		me.insert(addPosition, fieldContainer);
                    		//me.insert(7, fieldContainer);
                    		addPosition++;
                    		fieldColumnCount = 0;
                    		
                    	}
                        if (isCustomFieldExist) {
                        	var customHiddenId = Ext.create('Ext.form.field.Hidden',{
                    			name: 'customHiddenId'
                    		});
                        	var customHiddenVersion = Ext.create('Ext.form.field.Hidden',{
                    			name: 'customHiddenVersion'
                    		});
                    		me.insert(addPosition, customHiddenId);
                    		addPosition++;
                    		me.insert(addPosition, customHiddenVersion);
                    		me.setColumnNameToCustomFieldNameData({ 'columnName': 'customHiddenId'});
                    		me.setColumnNameToCustomFieldNameData({ 'columnName': 'customHiddenVersion'});
                        }
                    	me.doLayout();
            			
            		}
            	} else if(object.tableName === 'student_other_information'){
            		
            		Ext.Array.each(object.wsCustomFieldConfigModels, function(fieldObject) {
                		var field = me.getComponent(fieldObject, me);
                		itemArray.push(field);
                		if(itemArray[fieldColumnCount].id.includes("date")) {
                			itemArray[fieldColumnCount].editable =true;
                		}
                		fieldColumnCount++;
                        if(fieldColumnCount == columns){
                        	var fieldContainer = Ext.create('Ext.form.FieldContainer', {
                                width: 'auto',
                                margin: marginCustomField,
                                plugins : "formlabelrequired",
                                defaults: {
                                    labelAlign: 'top',
                                    width: 226
                                },
                                layout: {
                                    type: 'hbox'
                                },
                                items: itemArray
                            });
                        	me.insert(addPosition, fieldContainer);
                        	//me.insert(7, fieldContainer);
                        	itemArray = new Array();
                            addPosition++;
                        	fieldColumnCount = 0;
                        }
                        
                        isCustomFieldExist = true;
                    });
                    if(!isEmpty(itemArray)){
                		var fieldContainer = Ext.create('Ext.form.FieldContainer', {
                            width: 'auto',
                            plugins : "formlabelrequired",
                            defaults: {
                                labelAlign: 'top',
                                width: 226
                            },
                            layout: {
                                type: 'hbox'
                            },
                            items: itemArray
                        });
                		me.insert(addPosition, fieldContainer);
                		//me.insert(7, fieldContainer);
                		addPosition++;
                		fieldColumnCount = 0;
                		
                	}
                    if (isCustomFieldExist) {
                    	var customHiddenId = Ext.create('Ext.form.field.Hidden',{
                			name: 'customHiddenId'
                		});
                    	var customHiddenVersion = Ext.create('Ext.form.field.Hidden',{
                			name: 'customHiddenVersion'
                		});
                		me.insert(addPosition, customHiddenId);
                		addPosition++;
                		me.insert(addPosition, customHiddenVersion);
                		me.setColumnNameToCustomFieldNameData({ 'columnName': 'customHiddenId'});
                		me.setColumnNameToCustomFieldNameData({ 'columnName': 'customHiddenVersion'});
                    }
                	me.doLayout();
            		
            	} else {
            		
            		Ext.Array.each(object.wsCustomFieldConfigModels, function(fieldObject) {
                		var field = me.getComponent(fieldObject, me);
                		itemArray.push(field);
                		fieldColumnCount++;
                        if(fieldColumnCount == columns){
                        	var fieldContainer = Ext.create('Ext.form.FieldContainer', {
                                width: 'auto',
                                margin: marginCustomField,
                                plugins : "formlabelrequired",
                                defaults: {
                                    labelAlign: 'top',
                                    width: 226
                                },
                                layout: {
                                    type: 'hbox'
                                },
                                items: itemArray
                            });
                        	me.insert(addPosition, fieldContainer);
                        	//me.insert(7, fieldContainer);
                        	itemArray = new Array();
                            addPosition++;
                        	fieldColumnCount = 0;
                        }
                        
                        isCustomFieldExist = true;
                    });
                    if(!isEmpty(itemArray)){
                		var fieldContainer = Ext.create('Ext.form.FieldContainer', {
                            width: 'auto',
                            plugins : "formlabelrequired",
                            margin: marginCustomField,
                            defaults: {
                                labelAlign: 'top',
                                width: 226
                            },
                            layout: {
                                type: 'hbox'
                            },
                            items: itemArray
                        });
                		me.insert(addPosition, fieldContainer);
                		//me.insert(7, fieldContainer);
                		addPosition++;
                		fieldColumnCount = 0;
                		
                	}
                    if (isCustomFieldExist) {
                    	var customHiddenId = Ext.create('Ext.form.field.Hidden',{
                			name: 'customHiddenId'
                		});
                    	var customHiddenVersion = Ext.create('Ext.form.field.Hidden',{
                			name: 'customHiddenVersion'
                		});
                		me.insert(addPosition, customHiddenId);
                		addPosition++;
                		me.insert(addPosition, customHiddenVersion);
                		me.setColumnNameToCustomFieldNameData({ 'columnName': 'customHiddenId'});
                		me.setColumnNameToCustomFieldNameData({ 'columnName': 'customHiddenVersion'});
                    }
                	me.doLayout();
            		
            	}
            }
            
        });
    	
    },

    /**
     * This function return form field component on the basis of object data
     * 
     * @param object
     *          It is object which contains form field details
     */
    getComponent: function(object, me) {
    	var field = null;
        switch (object.customFieldDataType) {
        case 'COMBOBOX':
        	var storeName, extraParams;
        	if(object.whetherStandardMaster){
        		storeName = 'Academia.store.customcategories.DynamicStandardMasterCategoryComboStore';
        		extraParams = {
        				standardMasterCategoryId: object.standardMasterCategory.id
        		};
        	}else{
        		storeName = 'Academia.store.customcategories.DynamicCustomCategoryComboStore';
        		extraParams = {
        				customFieldConfigId: object.id
        		};
        	}
        	field = new Ext.form.ComboBox({
        		itemId: object.displayName,
                name: object.columnName,
                fieldLabel: object.displayName,
                valueField: 'id',
                labelAlign: 'top',
                width: 226,
                displayField: 'value',
                queryMode: 'local',
                editable: false,
                triggerAcation: 'all',
                fourceSelection: true,
                allowBlank: !object.whetherMandatory,
                listeners: {
                	render: function(combo) {
                        var store = Ext.create(storeName);
                        store.getProxy().extraParams = extraParams;
                        combo.bindStore(store);
                        store.load();
                    }
                }
            });
            break;
        case 'TEXTFIELD':
        	field = new Ext.form.TextField({
                fieldLabel: object.displayName,
                name: object.columnName,
                itemId: object.displayName,
                labelAlign: 'top',
                width: 226,
                allowBlank: !object.whetherMandatory
            });
            break;
        case 'CHECKBOX':
        	field = new Ext.form.field.Checkbox({
        		boxLabel: object.displayName,
                name: object.columnName,
                itemId: object.displayName,
                allowBlank: !object.whetherMandatory,
                inputValue: 'true',
                uncheckedValue: 'false'
            });
        	break;
        case 'TEXTAREA':
        	field = new Ext.form.field.TextArea({
                fieldLabel: object.displayName,
                name: object.columnName,
                itemId: object.displayName,
                maxLength: 255,
                labelAlign: 'top',
                width: 226,
                allowBlank: !object.whetherMandatory
            });
        	break;
        case 'DATEFIELD':
        	field = new Ext.form.field.Date({
                fieldLabel: object.displayName,
                name: object.columnName,
                itemId: object.displayName,
                allowBlank: !object.whetherMandatory,
                editable: false,
                labelAlign: 'top',
                width: 226,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
            });
        	break;
        	
        }
        me.setColumnNameToCustomFieldNameData(object);
        
        return field;
    },
    
    setColumnNameToCustomFieldNameData: function(object){
    	var me = this;
    	if(!isNullOrEmpty(object.columnName)){
        	me.customFieldNameData.push(object.columnName);
        }
    },
    /**
     * Set values for fields in this form in bulk.
     *
     * @param {Object/Object[]} values Either an array in the form:
     *
     *     [{id:'clientName', value:'Fred. Olsen Lines'},
     *      {id:'portOfLoading', value:'FXT'},
     *      {id:'portOfDischarge', value:'OSL'} ]
     *
     * or an object hash of the form:
     *
     *     {
     *         clientName: 'Fred. Olsen Lines',
     *         portOfLoading: 'FXT',
     *         portOfDischarge: 'OSL'
     *     }
     *
     * @return {Ext.form.Basic} this
     */
    setFormValues: function(values) {
    	var me = this.getForm(),
    	v, vLen, val, field;

    	function setVal(fieldId, val) {
    		var field = me.findField(fieldId);
    		if (field) {
    			if(field.name == 'cf14' || field.name == 'cf15') {
    				field.setValue(dateRender(val));
    			} else {
    				field.setValue(val);
    			}
    			if (me.trackResetOnLoad) {
    				field.resetOriginalValue();
    			}
    		}
    	}

    	// Suspend here because setting the value on a field could trigger
    	// a layout, for example if an error gets set, or it's a display field
    	Ext.suspendLayouts();
    	if (Ext.isArray(values)) {
    		// array of objects
    		vLen = values.length;

    		for (v = 0; v < vLen; v++) {
    			val = values[v];

    			setVal(val.id, val.value);
    		}
    	} else {
    		// object hash
    		Ext.iterate(values, setVal);
    	}
    	// Checking the customData and set to form field
    	if(values != undefined) {
    		if(values.hasOwnProperty("customData") && !isEmpty(values.customData)){
    			if (Ext.isArray(values.customData)) {
    				// array of objects
    				var customData = values.customData;
    				vLen = customData.length;

    				for (v = 0; v < vLen; v++) {
    					val = customData[v];
    					if(!isNullOrEmpty(val.id)){
    						val.customHiddenId = val.id;
    						delete val.id;
    					}
    					if(!isNullOrEmpty(val.version)){
    						val.customHiddenVersion = val.version;
    						delete val.version;
    					}
    					Ext.iterate(val, setVal);
    				}
    			}
    		}

    		Ext.resumeLayouts(true);
    		return this;
    	}
    },
    /**
     * Retrieves the fields in the form as a set of key/value pairs, using their
     * {@link Ext.form.field.Field#getSubmitData getSubmitData()} method to collect the values.
     * If multiple fields return values under the same name those values will be combined into an Array.
     * This is similar to {@link Ext.form.Basic#getFieldValues getFieldValues} except that this method
     * collects only String values for submission, while getFieldValues collects type-specific data
     * values (e.g. Date objects for date fields.)
     *
     * @param {Boolean} [asString=false] If true, will return the key/value collection as a single
     * URL-encoded param string.
     * @param {Boolean} [dirtyOnly=false] If true, only fields that are dirty will be included in the result.
     * @param {Boolean} [includeEmptyText=false] If true, the configured emptyText of empty fields will be used.
     * @param {Boolean} [useDataValues=false] If true, the {@link Ext.form.field.Field#getModelData getModelData}
     * method is used to retrieve values from fields, otherwise the {@link Ext.form.field.Field#getSubmitData getSubmitData}
     * method is used.
     * @return {String/Object}
     */
    getFormValues: function(asString, dirtyOnly, includeEmptyText, useDataValues) {
    	var me = this;
		var values  = {},
        fields  = me.getForm().getFields().items,
        f,
        fLen    = fields.length,
        isArray = Ext.isArray,
        field, data, val, bucket, name;

        for (f = 0; f < fLen; f++) {
            field = fields[f];

            if (!dirtyOnly || field.isDirty()) {
                data = field[useDataValues ? 'getModelData' : 'getSubmitData'](includeEmptyText);

                if (Ext.isObject(data)) {
                    for (name in data) {
                        if (data.hasOwnProperty(name)) {
                            val = data[name];

                            if (includeEmptyText && val === '') {
                                val = field.emptyText || '';
                            }

                            if (values.hasOwnProperty(name)) {
                                bucket = values[name];

                                if (!isArray(bucket)) {
                                    bucket = values[name] = [bucket];
                                }

                                if (isArray(val)) {
                                    values[name] = bucket.concat(val);
                                } else {
                                    bucket.push(val);
                                }
                            } else {
                                values[name] = val;
                            }
                        }
                    }
                }
            }
        }

        if (asString) {
            values = Ext.Object.toQueryString(values);
        }
        values = me.getCustomFieldFormDataValues(values);
        return values;
    },
    
    /**
     * set custom field values to form values to send in json format
     * @param values form values
     */
    getCustomFieldFormDataValues: function(values){
    	var me = this;
    	var customData =  new Array();
    	var customFieldData = new Object();
    	if(me.hasOwnProperty("customFieldNameData")){
    		Ext.Array.each(me.customFieldNameData, function(customName) {
    			if(!isNullOrEmpty(customName)){
    				if(customName == 'customHiddenId'){
            			customFieldData['id'] = values[customName];
            		}else if(customName == 'customHiddenVersion'){
            			customFieldData['version'] = values[customName];
            		}else{
            			customFieldData[customName] = values[customName];
            		}
    				delete values[customName];
    			}
        		
            });
    		if(!isEmpty(customFieldData)){
        		customData.push(customFieldData);
        	}
    		values.customData = customData;
    	}
    	
    	return values;
    }
    
});
