/**
 * @Author Prathamesh.Sheth
 * 
 * This is extended form component to show custom fields of entities.  
 */
Ext.define('Academia.view.common.CustomForm', {

    extend: 'Ext.form.Panel',

    alias: 'widget.customform',
    
   /* requires :['Academia.view.customfields.EntityCustomFieldFormWindow' ], */

    customFieldEntity: '',

    customFieldFormWindow: null,

    customFieldFormData: new Array(),
    
    constructor: function(cnfg) {
        this.callParent(arguments); //Calling the parent class constructor
        this.initConfig(cnfg); //Initializing the component
        this.getForm().getValues = Ext.bind(this.basicFormGetValues, this); //Binding external function to basic form component
        this.getForm().setValues = Ext.bind(this.basicFormSetValues, this);
        this.on('render', this.render); //Associating a new defined method with an event		
    },

    /**
     * This function is used for to add custom field link if entity having custom fields.
     * 
     * @param cmp
     *          It is form component on listening render event
     */
    render: function(cmp, eOpts) {
        var me = this;
        var customFieldDataModel = Academia.model.customfields.CustomFieldDataModel;
        var isExist = false;

        Ext.Array.each(customFieldDataModel.customFieldData, function(entityObject) {
            if (!isNullOrEmpty(me.customFieldEntity) && entityObject.entityName === me.customFieldEntity && entityObject.entityFieldMetaDatas.length > 0) {
                entityObject.entityFieldMetaDatas.sort(function(a, b) {
                    return a.displayOrder - b.displayOrder;
                });
                isExist = true;
            }
        });
        if (isExist == true) {
            var customFieldLinkCmp = me.getCustomFieldLinkCmp(me);
            cmp.add(customFieldLinkCmp);
            cmp.doLayout();
        }
    },

    /**
     * This function is used for to get custom field link and also catch click event of that link in that
     * we show custom field form and add fields dynamically on that form component. 
     * 
     * @param me
     *          passing form reference to this function
     */
    getCustomFieldLinkCmp: function(me) {
        var customFieldLink = {
            xtype: 'component',
            itemId: 'customFieldComponent',
            autoEl: {
                tag: 'a',
                href: '#',
                html: getCommonTranslation('CUSTOM_FIELD') //Custom Field
            },
            listeners: {
                click: {
                    element: 'el', //bind to the underlying el property on the panel
                    fn: function(el) {
                        me.customFieldFormWindow = Ext.widget('entitycustomfieldformwindow');
                        var customFieldDataModel = Academia.model.customfields.CustomFieldDataModel;
                        Ext.Array.each(customFieldDataModel.customFieldData, function(object) {
                            if (!isNullOrEmpty(me.customFieldEntity) && object.entityName === me.customFieldEntity && object.entityFieldMetaDatas.length > 0) {
                                var fieldPosition = 0;
                                Ext.Array.each(object.entityFieldMetaDatas, function(fieldObject) {
                                    var field = me.getComponent(fieldObject, me);
                                    me.customFieldFormWindow.down('#customFieldForm').insert(fieldPosition, field);
                                    me.customFieldFormWindow.doLayout();
                                    fieldPosition++;
                                });
                            }
                        });
                        me.customFieldFormWindow.on('afterrender', me.showCustomFieldsFormData, me);
                        me.customFieldFormWindow.show();
                        me.customFieldFormWindow.down('#academyFormCancelButtonId').on('click', me.closeCustomFieldsFormWindow, me);
                        me.customFieldFormWindow.down('#academyFormSubmitButtonId').on('click', me.submitCustomFieldsFormWindow, me);
                    }
                }
            }
        };
        return customFieldLink;
    },

    /**
     * This function return form field component on the basis of object data
     * 
     * @param object
     *          It is object which contains form field details
     */
    getComponent: function(object) {
        switch (object.customFieldDataType) {
        case 'TEXTFIELD':
            var text = new Ext.form.TextField({
                fieldLabel: object.displayCode,
                name: object.displayCode,
                itemId: object.displayCode,
                customData: new Object({
                    id: null,
                    entityFieldMetaDataId: object.id
                }),
                allowBlank: !object.whetherMandatory
            });
            return text;
        case 'CHECKBOX':
            var checkbox = new Ext.form.field.Checkbox({
                fieldLabel: object.displayCode,
                name: object.displayCode,
                itemId: object.displayCode,
                allowBlank: !object.whetherMandatory,
                inputValue: 'true',
                customData: new Object({
                    id: null,
                    entityFieldMetaDataId: object.id
                }),
                uncheckedValue: 'false'
            });
            return checkbox;
        case 'TEXTAREA':
            var textArea = new Ext.form.field.TextArea({
                fieldLabel: object.displayCode,
                name: object.displayCode,
                itemId: object.displayCode,
                maxLength: 200,
                customData: new Object({
                    id: null,
                    entityFieldMetaDataId: object.id
                }),
                allowBlank: !object.whetherMandatory
            });
            return textArea;
        case 'DATEFIELD':
            var date = new Ext.form.field.Date({
                fieldLabel: object.displayCode,
                name: object.displayCode,
                itemId: object.displayCode,
                allowBlank: !object.whetherMandatory,
                editable: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                customData: new Object({
                    id: null,
                    entityFieldMetaDataId: object.id
                }),
                format: CONSTANTS.DATE_FORMAT
            });
            return date;
        }
    },

    /**
     * This function is used for to close custom field form window
     * 
     */
    closeCustomFieldsFormWindow: function() {
        this.customFieldFormWindow.close();
    },

    /**
     * This function is used to create custom field form data object. 
     *      
     */
    submitCustomFieldsFormWindow: function(cmp) {
        var customFieldData = new Array();
        this.customFieldFormWindow.down('#customFieldForm').getForm().getFields().each(function(field) {
            var customFieldDataObject = new Object();
            var customData = field.initialConfig.customData;
            if (!isEmpty(customData)) {
                customFieldDataObject.id = customData.id;
                customFieldDataObject.entityFieldMetaDataId = customData.entityFieldMetaDataId;
                customFieldDataObject.data = field.getSubmitValue();
            }
            customFieldData.push(customFieldDataObject);
        });
        this.customFieldFormData = customFieldData;
        this.customFieldFormWindow.close();
    },

    /**
     * This function is used for to set custom field form data.
     * 
     */
    showCustomFieldsFormData: function() {
        var me = this;
        if (me.customFieldFormData.length > 0) {
            me.customFieldFormWindow.down('#customFieldForm').getForm().getFields().each(function(field) {
                var dataObject = me.getFieldData(field, me);
                if (!isEmpty(dataObject)) {
                    var customDataObject = new Object();
                    customDataObject.id = dataObject.id;
                    customDataObject.entityFieldMetaDataId = dataObject.entityFieldMetaDataId;
                    field.initialConfig.customData = customDataObject;
                    field.setValue(dataObject.data);
                }
            });
        }
    },

    /**
     * This function is return data object from custom field form data on the basis of entityFieldMetaDataId.  
     * 
     * @param field 
     *          It is form field of custom form 
     *      
     * @param me
     *          passing form reference to function         
     */
    getFieldData: function(field, me) {
        var dataObject = new Object();
        var customData = field.initialConfig.customData;
        if (!isEmpty(me.customFieldFormData) && !isEmpty(customData)) {
            for (var count = 0; count < me.customFieldFormData.length; count++) {
                if (customData.entityFieldMetaDataId == me.customFieldFormData[count].entityFieldMetaDataId) {
                    dataObject.id = me.customFieldFormData[count].id;
                    dataObject.entityFieldMetaDataId = me.customFieldFormData[count].entityFieldMetaDataId;
                    dataObject.data = me.customFieldFormData[count].data;
                }
            }
        }
        return dataObject;
    },

    /**
     * Override and extend getValues() method of form panel and add custom field form data  
     * 
     */
    getValues: function() {
    	if(this.isExistMandatoryFieldData(this)){
    		showInfoMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_CUSTOM_FIELDS')); //'Please enter the values for Mandatory Custom Fields'
    	}else{
    		var values = this.callParent(arguments);
            values.customFieldDatas = this.customFieldFormData;
            return values;
    	}        
    },

    /**
     * Override and extend setValues() method of form panel and set custom field form data
     * 
     * @param values 
     *            passing form values to this function
     * 
     */
    setValues: function(values) {    	   
    	if (!isEmpty(values.customFieldDatas)) {
            this.customFieldFormData = values.customFieldDatas;
        }
        this.callParent(arguments);
    },

    /**
     * Override getValues() method of basic form and add custom field form data  
     *       In case use this form.getForm().getValues() then in that case this function 
     * will get call else above getValues() function will get call. 
     * 
     */
    basicFormGetValues: function(asString, dirtyOnly, includeEmptyText, useDataValues) {
    	if(this.isExistMandatoryFieldData(this)){
    		showInfoMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_CUSTOM_FIELDS')); //'Please enter the values for Mandatory Custom Fields'
    	}else{
    		var values = {},
            fields = this.getForm().getFields().items,
            f,
            fLen = fields.length,
            isArray = Ext.isArray,
            field, data, val, bucket, name;

        for (f = 0; f < fLen; f++) {
            field = fields[f];

            if (!dirtyOnly || field.isDirty()) {
                data = field[useDataValues ? 'getModelData' : 'getSubmitData'](includeEmptyText);

                if (Ext.isObject(data)) {
                    for (name in data) {
                        if (data.hasOwnProperty(name)) {
                            val = data[name];

                            if (includeEmptyText && val === '') {
                                val = field.emptyText || '';
                            }

                            if (values.hasOwnProperty(name)) {
                                bucket = values[name];

                                if (!isArray(bucket)) {
                                    bucket = values[name] = [bucket];
                                }

                                if (isArray(val)) {
                                    values[name] = bucket.concat(val);
                                } else {
                                    bucket.push(val);
                                }
                            } else {
                                values[name] = val;
                            }
                        }
                    }
                }
            }
        }

        if (asString) {
            values = Ext.Object.toQueryString(values);
        }
        
        values.customFieldDatas = this.customFieldFormData;
        return values;
    	}
    },

    /**
     * Override getValues() method of basic form and set custom field form data  
     *       In case use this form.getForm().setValues() then in that case this function 
     * will get call else above setValues() function will get call.
     * 
     * @param values 
     *            passing form values to this function
     */
    basicFormSetValues: function(values) {    	
    		if (!isEmpty(values.customFieldDatas)) {
                this.customFieldFormData = values.customFieldDatas;
            }

            var me = this.getForm(),
                v, vLen, val, field;

            function setVal(fieldId, val) {
                var field = me.findField(fieldId);
                if (field) {
                    field.setValue(val);
                    if (me.trackResetOnLoad) {
                        field.resetOriginalValue();
                    }
                }
            }

            Ext.suspendLayouts();
            if (Ext.isArray(values)) {
                // array of objects
                vLen = values.length;

                for (v = 0; v < vLen; v++) {
                    val = values[v];

                    setVal(val.id, val.value);
                }
            } else {
                // object hash
                Ext.iterate(values, setVal);
            }
            Ext.resumeLayouts(true);
            return this;    
    },
    
    /**
     * This function is used for to check mandatory custom field form data.
     * 
     */
    isExistMandatoryFieldData: function(me) {        
        var isExistMandatoryFieldData=false;
        var customFieldDataModel = Academia.model.customfields.CustomFieldDataModel;
        Ext.Array.each(customFieldDataModel.customFieldData, function(object) {
            if (!isNullOrEmpty(me.customFieldEntity) && object.entityName === me.customFieldEntity && object.entityFieldMetaDatas.length > 0) {                
                Ext.Array.each(object.entityFieldMetaDatas, function(fieldObject) {
                	if(fieldObject.whetherMandatory){
                		var dataobject=me.checkMandatoryCustomFieldData(fieldObject,me);
                		if(isNullOrEmpty(dataobject.data)){
                			isExistMandatoryFieldData=true;                			
                		}                	    	
                	}                               
                });
            }
        });
        return isExistMandatoryFieldData;
    },

    /**
     * This function is return data object from custom field form data on the basis of entityFieldMetaDataId and fieldObject.id.  
     * 
     * @param fieldObject
     *          It is object which contain form field details 
     *      
     * @param me
     *          passing form reference to function
     */
    checkMandatoryCustomFieldData: function(fieldObject, me) {
        var dataObject = new Object();        
        if (!isEmpty(me.customFieldFormData) && !isNullOrEmpty(fieldObject.id)) {
            for (var count = 0; count < me.customFieldFormData.length; count++) {
                if (fieldObject.id == me.customFieldFormData[count].entityFieldMetaDataId) {
                    dataObject.id = me.customFieldFormData[count].id;
                    dataObject.entityFieldMetaDataId = me.customFieldFormData[count].entityFieldMetaDataId;
                    dataObject.data = me.customFieldFormData[count].data;
                }
            }
        }
        return dataObject;
    }
});
