Ext.define('Academia.view.common.NestedJsonCombo',{
	extend:'Ext.form.ComboBox',
	alias:'widget.nestedJsonCombo',
	overrideSetValue:true,
	overridetSubmitData: true,
	getArrayValue: false,
	maskRe: /[^%]/,
	
	listeners: {
		change: function(obj, newValue, oldValue, opt){
			if(!Ext.isObject(newValue)){
			if(!Ext.isNumber(newValue) && newValue && newValue.match(/%/)){
				obj.setValue(oldValue);
			   }
			}
		}
	},
	listConfig: {
		listeners: {
			beforeshow: function(picker) {
				if(picker){
					var combo = picker.up('combobox');
					if(combo){
						picker.setWidth(combo.getWidth());
					}
				}
			}
		}
	},
    getSubmitData: function() {
        var this$ = this,
            data = {},
            value;
        var fieldName=this$.name;
        if (!this$.disabled && this$.submitValue) {
            value = this$.getValue();
            if (value !== null){
            	if (this$.overridetSubmitData ) {
	                var customValue = new Object();
	                customValue.id = value;
	                data[fieldName] = customValue;
	            }else if (this$.getArrayValue ) {
	            	var array=new Array();
	    			array.push(value);
	    			data[fieldName] =array;
	            }else{
	            	data[fieldName] =value;
	            }
            }
        }
        return data;
    },
    setValue: function(value, take) {
    	  var this$ = this;
        if (this$.overrideSetValue && value && value.constructor === Object){
        	if (value.hasOwnProperty('id')) {
        		value = value["id"];
	    		if(this$.store.data.items.length<1){
	    			this$.store.load();
	    			this$.queryMode='local';
	            }
            }
        }
    	  this$.callParent(arguments);
        return this$;
    },
    /**
     * for template alternate color
     */
    constructor: function (args) {
    	var me = this;
    	if(me.xtype=='nestedJsonCombo'){
    		var displayField = args.displayField;
    		args.tpl = new Ext.XTemplate(
	            '<tpl for=".">',
	            '<tpl if="xindex%2==0"><div class="x-boundlist-item combo-even"></tpl><tpl  if="xindex%2==1"><div class="x-boundlist-item combo-odd"></tpl> {' + displayField + '} </div>',
	            '</tpl>'
	        );
    	}
    	else if(me.xtype=='livesearchcombo'){
    		args.tpl = new Ext.XTemplate(
	            '<tpl for=".">',
	            '<tpl if="xindex%2==0"><div class="x-boundlist-item combo-even"></tpl><tpl  if="xindex%2==1"><div class="x-boundlist-item combo-odd"></tpl> {' + me.displayField + '} </div>',
	            '</tpl>'
	        );
    	}
    	me.callParent(arguments);
    }
});

