/**
 * This is custom field for nested textfield value.
 * @author Rupesh.Agrawal
 */
Ext.define('Academia.view.common.NestedTextField', {
    extend: 'Ext.form.field.Text',
    alias: 'widget.nestedTextField',
    objectId: null,
    displayField:null,
    
    getSubmitData: function() {
        var this$ = this,
            data = null,
            value;
        var fieldName = this$.name;
        if (!this$.disabled && this$.submitValue) {
            value = this$.getValue();
                       
            if (value !== null) {
            	 var customValue = new Object();
        	    data = new Object();
        	    if (this$.objectId !== null) {
        	    	 customValue.id = this$.objectId;
        	    }else{
        	    	 customValue.id =value;
        	    }
        	    if (this$.displayField !== null) {
       	    	 customValue[this$.displayField] =value;
        	    }
        	    	
                data[fieldName] = customValue;
            }
        }
        return data;
    },
    setValue: function(value, take) {
        var this$ = this;
        if (value && value.constructor === Object) {
            if (value.hasOwnProperty('id')) {
            	this$.objectId = value["id"];
            }
            if (this$.displayField && value.hasOwnProperty(this$.displayField)) {
            	value= value[this$.displayField];
            }else  if (value.hasOwnProperty('id')) {
            	value= value["id"];
            }
        }
        this$.callParent(arguments);
        return this$;
    }
});
